/*
 * IDLflex -- A flexible, generic code generator for CORBA IDL
 *
 * Copyright (C) 2000  Hans Reiser, AspectIX Research Team
 *                     University of Erlangen-Nuernberg, Germany
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License.
 * The full text of the license can be found in the LICENSE.txt file.
 *
 * $Id: Counter.java,v 1.3 2001/09/07 09:20:42 reiser Exp $
 */

package org.aspectix.IDLflex;

/** This class is used as a plugin object which can be used as a
 *  simple counter. It is initialized with the value 0, supports the
 *  command "inc" to increment this value, and provides getName access
 *  to return this value as string (decimal number).
 */
public class Counter extends Plugin {
    protected int value;
    public Counter() {
	value=0;
    }
    public String getName(String spec) {
	return ""+value;
    }
    public void execCmd(String spec) throws IDLflexException{
	if(spec.equals("inc")) {
	    value++;
	} else {
	    throw new IDLflexException("Conuter: unknown command"+spec);
	}
    }
}
