/*
 * IDLflex -- A flexible, generic code generator for CORBA IDL
 *
 * Copyright (C) 2001  Franz J. Hauck, AspectIX Research Team
 *                     University of Erlangen-Nuernberg, Germany
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License.
 * The full text of the license can be found in the LICENSE.txt file.
 *
 * $Id: Debug.java,v 1.3 2002/02/26 10:46:09 reiser Exp $
 */

package org.aspectix.IDLflex;

/** Class to support debug output messages.
 */
public final class Debug
{
    // Debug levels
    public static final int QUIET = 0;
    public static final int IMPORTANT = 1;
    public static final int INFO = 2;
    public static final int TRACE = 3;

    // Debug sections
    public static final int IRO = 0;
    public static final int IDLflex = 1;
    public static final int IDLparser = 2;
    public static final int MAX_SECTIONS = 3;		// highest value +1

    /**	Section names.
     */
    private static String[] sections= new String[] { "IRO", 
						     "IDLflex", 
						     "IDLparser" };

    /**	Variable to hold debug output configuration
     */
    private static int[] debugConfig= { QUIET, QUIET, QUIET };
    

    public static void setVerbose(int level) {
	for(int i=0; i<MAX_SECTIONS-1; i++) {
	    debugConfig[i] = level;
	}
    }

    public static int verbose(int level) {
	return debugConfig[level];
    }

    /**	Print debug message.
     */
    public static void print(int level, int section, String msg )
    {
	if( debugConfig[section] >= level )
	{
	    System.err.println( "IDLflex(" + level + "/" +sections[section] +
	    			"): " + msg );
	}
    }

    /** Dump exception.
     */
    public static void print(int section, Exception ex )
    {
	System.err.println( "IDLflex("+sections[section]+"): ");
	if (debugConfig[section] >= INFO ) {
	    ex.printStackTrace();
	} else {
	    System.err.println(ex);
	}
    }
}
