/*
 * IDLflex -- A flexible, generic code generator for CORBA IDL
 *
 * Copyright (C) 2000  Hans Reiser, AspectIX Research Team
 *                     University of Erlangen-Nuernberg, Germany
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License.
 * The full text of the license can be found in the LICENSE.txt file.
 *
 * $Id: IDLFileWriter.java,v 1.5 2001/11/22 13:34:19 reiser Exp $
 */

package org.aspectix.IDLflex;

import java.io.File;
import java.io.FileWriter;
import java.io.BufferedWriter;
import java.io.Writer;
import java.io.IOException;

/** base class for creating and writing into a file.
 */
public class IDLFileWriter implements IDLWriter {
    Writer out = null;
    String buffer = "";
    //static java.util.Vector reopenFiles;
    //static {
    //reopenFiles = new java.util.Vector();
    // }

    /** public constructor, which automatically creats the file of the
     *  given name.
     */
    public IDLFileWriter() {
    }

    public void setDelegate(Writer delegate) {
	out = delegate;
	//System.err.println("IDLFileWriter: delegating to "+out.getClass());
	//try { out.write("Hello"); } catch(Exception ex) {};
    }

    /** writes a String into the file... */
    public void write(String s) throws IOException {
	//if(s.startsWith("\n")) s=s.substring(1);
	//if(s.endsWith("\n")) s=s.substring(0,s.length()-1);
	//// s=" >"+s.trim()+"< ";
	buffer+=s;
	int pos;
	while( (pos = buffer.indexOf("\n")) >=0 ) {
	    out.write(buffer.substring(0,pos+1));
	    buffer=buffer.substring(pos+1);
	}
    }

    /** flushes the internal buffer and closes the file.
     *  It is essential to call the close methode, otherwise the
     *  internal buffer will not be written to the file.
     */
    public void close() throws IOException {
	out.write(buffer);
	out.flush();
	out.close();
    }
}
