package org.aspectix.IDLflex;

import org.aspectix.IDLflex.IRObj.IDLObject;
import java.util.Vector;
import org.w3c.dom.Node;

/** The class IDLObjectVector is used to record a list
 *  of objects which represent the history of IDL reference objects
 *  and XML reference nodes. If an error occurs, this information is
 *  used to print out path history information. When reaching the
 *  end of the current XML element, this data structure is used to
 *  restore the previous XML and IDL references.
 */
class IDLObjectVector {
    Vector nodes;
    Vector objects;
    public IDLObjectVector() { 
	objects = new Vector(); 
	nodes = new Vector();
    }
    public void addObject(IDLObject obj) { objects.addElement(obj); }
    public void addNode(Node n) { nodes.addElement(n); }
    public void removeLastObject() {
	objects.removeElementAt(objects.size()-1);
    }
    public void removeLastNode() {
	nodes.removeElementAt(nodes.size()-1);
    }
    public IDLObject getLastObject() {
	return (IDLObject)( objects.elementAt(objects.size()-1) );
    }
    /* retrievs object from object stack 'n' positions up from end,
     * SKIPPING ALL REPEATED OBJECTS
     */
    public IDLObject getUpperObject(int n) {
	int pos = objects.size()-1;
	IDLObject upper = (IDLObject)objects.elementAt(pos);
	while(n>0) {
	    pos--;
	    if(pos<0) return null; // TODO: error
	    if( upper != (IDLObject)objects.elementAt(pos) ) {
		upper = (IDLObject)objects.elementAt(pos);
		n--;
	    }
	}
	return upper;
    }
    public Node getLastNode() {
	return (Node)( nodes.elementAt(nodes.size()-1) );
    }
    public IDLObject objectAt(int i) {
	return (IDLObject)(objects.elementAt(i));
    }
    public Node nodeAt(int i) {
	return (Node)(nodes.elementAt(i));
    }
    public int count_nodes() { return nodes.size(); }
    public int count_objects() { return objects.size(); }
}
