package org.aspectix.IDLflex;

import java.io.*;
import java.util.Hashtable;
import java.util.Enumeration;

public class IDLOutputList {
    private Class writerclass;

    // Maps File name specified by IDL mapping to an object vector 
    // First object is IDL-ID (string) or array of IDL-ID
    // Second object is:
    //    DST_FILE and TMPDST_FILE:  pathname to file on disk
    //    DST_STRING:         StringWriter object
    // First string is IDL-ID, second string is path to file on disk
    // or memory object holding the output
    private Hashtable writerlist;
    private String writepath;

    public final static int DST_FILE = 1;
    public final static int DST_STRING = 2;
    private int dsttype;

    public IDLOutputList(Class wcls, String wpath, int mode)
    {
	writepath = wpath;
	writerclass = wcls;
	dsttype = mode;
	writerlist = new Hashtable();
    }

    public Hashtable getFiles() {
	Hashtable ret = new Hashtable();
	Enumeration en = writerlist.keys();
	while(en.hasMoreElements()) {
	    String key = (String)en.nextElement();
	    Object[] value = (Object[])writerlist.get(key);
	    ret.put(key, value[0]);
	}
	//System.err.println("IDLOutputList: returning "+ret.size()+" elements");
	return ret;
    }

    public java.io.Reader getFileReader(String filespec)
	throws java.io.IOException
    {
	Object[] value = (Object[])writerlist.get(filespec);
	if(value==null) return null;

	if(dsttype==DST_FILE) {
	    String path = (String)value[1];
	    return new FileReader(path);
	}
	else if (dsttype==DST_STRING) {
	    StringWriter sw = (StringWriter)value[1];
	    String s = sw.toString();
	    return new StringReader(s);
	}
	else return null;
    }

    public IDLWriter open(String filename, String idlid, String mode)
	throws IDLflexException
    {
	Object[] val;

	val = (Object[])writerlist.get(filename);
	if(val!=null) {
	    System.err.println("WARNING: reopening "+filename);
	    // TODO: FIXME: Das geht noch nicht
	    // (reopen wie unten mit APPEND fr Datei, ansonsten an vorhandenen
	    // stringbuffer irgendwie anhngen... (?)
	    //IDLWriter outwr = (IDLWriter)writerlist.get(filename);
	    //return outwr;
	}

	val = new Object[2];
	val[0] = idlid;
	Writer out;
	if(dsttype==DST_FILE) {
	    File file = new File(writepath, filename);
	    
	    // Create directories if they do not exist
	    String pathstr = file.getParent();
	    if(pathstr!=null) {
		File path = new File(file.getParent());
		if(!path.exists()) {
		    if( path.mkdirs()==false ) {
			throw new IDLflexException("Cannot create directories"+
						   "for "+file.getPath());
		    }
		}
	    }

	    // Decide weather to append to or overwrite file
	    boolean append=false;
	    if(mode.equals("")||mode.equals("CREATE")) append=false;
	    else if(mode.equals("APPEND")) append=true;
	    //else if(mode.equals("REOPEN")) append=reopenFiles.contains(file);
	    //reopenFiles.addElement(file);
	    try {
		out=new BufferedWriter(new FileWriter(file.getPath(),append));
	    } catch(java.io.IOException ex) {
		throw new IDLflexException("Cannot create file "+
					   file.getPath()+":\n"+ex);
	    }
	    val[1] = file.getPath();
	} else if (dsttype==DST_STRING) {
	    StringWriter s = new StringWriter();
	    val[1] = s;
	    out = s;
	} else return null;
	
	writerlist.put(filename, val);
	//System.err.println("IDLOutputList: adding "+filename+" to list");
	IDLFileWriter writer;
	try {
	    writer = (IDLFileWriter)(writerclass.newInstance());
	} catch(Exception ex) {
	    throw new IDLflexException("IDLOutputList: Creating IDLWriter "+
				       "failed for "+filename);
	}
	writer.setDelegate(out);
	return writer;
    }
}
