/*
 * IDLflex -- A flexible, generic code generator for CORBA IDL
 *
 * Copyright (C) 2000  Hans Reiser, AspectIX Research Team
 *                     University of Erlangen-Nuernberg, Germany
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License.
 * The full text of the license can be found in the LICENSE.txt file.
 *
 * $Id: IDLStringWriter.java,v 1.2 2000/12/15 15:32:25 fzhauck Exp $
 */

package org.aspectix.IDLflex;

import java.io.IOException;
import java.io.StringWriter;

/** Implementation of an output stream which writes into a string.
 *  Used by the SaveBox ( \&lt;SBOX&gt; )
 */
public class IDLStringWriter implements IDLWriter {
    StringWriter str;

    public IDLStringWriter() {
	str = new StringWriter();
    }

    public String toString() {
	return str.toString();
    }

    public void write(String s) throws IOException {
	str.write(s);
    }
    public void close() throws IOException {
	str.close();
    }
    public void setindent() {}; 
    public void clearindent() {};
}
