package org.aspectix.IDLflex;

import java.io.*;
import java.util.Vector;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.omg.CORBA.Repository;
import org.aspectix.IDLflex.IRObj.IDLObject;
import org.aspectix.IDLflex.IRObj.ObjectCreator;
import org.aspectix.IDLflex.IRObj.FimoObjectCreator;
import org.aspectix.IDLparser.pub.IDLNode;

public class IDLcompiler {
//    String preprocess =  "gcc -x c++ -E -idirafter .";

    private IDLDefCompiler comp;

    /** Create a new IDL compiler object based on the specified xml mapping 
     *  program
     */
    public IDLcompiler(String xmlfile) throws IDLflexException {
	Hashtable config = new Hashtable();
	config.put("IDLflexMapping", xmlfile);
	
	config.put("IDLflexIncludeID", IDLflexMain.argsInclude );
	config.put("IDLflexExcludeID", IDLflexMain.argsExclude );
	
	// Add Attribute defined by -D
	int len = IDLflexMain.argsAttributes.names.length;
	for(int i=0; i<len; i++) {
	    config.put("DEF:"+IDLflexMain.argsAttributes.names[i],
		       IDLflexMain.argsAttributes.values[i]);
	}

	comp = new IDLDefCompiler(config);
    }

    /** Create an IDL object tree.
     *  FILE:xxx.idl            -> Fimo Parser
     *  JAVAORBIOR:ir-ior       -> external Interface Repository
     *  JAVAORBIDL:xxx.idl      -> idl file parsed by Interface Repository
     */
    public static IDLObject getIDLObjects(String IDLfile)
	throws IDLflexException 
    {
	if(IDLfile.startsWith("FILE:")) 
	    return getFimoIDLObjects(IDLfile.substring(5));
	if(IDLfile.startsWith("JAVAORBIDL:"))
	    return getJavaOrbIdlIDLObjects(IDLfile.substring(11));
	if(IDLfile.startsWith("JAVAORBIOR:"))
	    return getJavaOrbIorIDLObjects(IDLfile.substring(11));
	return getFimoIDLObjects(IDLfile);
    }
    
    /** Generate code, output is written to a file */
    public IDLOutputList generateCodeFiles(IDLObject idlobj)
	throws IDLflexException 
    {
	return generateCodeFiles(idlobj, null);
    }
    public IDLOutputList generateCodeFiles(IDLObject idlobj, String component) 
	throws IDLflexException 
    {
	return comp.generateCode(component, idlobj, IDLOutputList.DST_FILE);
    }

    /** Generate code, output is available via table of streams */
    public IDLOutputList generateCodeStreams(IDLObject idlobj)
	throws IDLflexException
    {
	return generateCodeStreams(idlobj, null);
    }
    public IDLOutputList generateCodeStreams(IDLObject idlobj, 
					     String component)
	throws IDLflexException
    {
	return comp.generateCode(component, idlobj, IDLOutputList.DST_STRING); 
    }

    /** Generate code for a simple <GET T="xxx"> statement, output is available
     *  as String
     */
    public String executeGET(IDLObject idlobj, String spec) 
	throws IDLflexException
    {
	return comp.util.getName(spec, idlobj);
    }

    public String executeGET(IDLObject root, String objref, String spec) 
	throws IDLflexException
    {
	IDLObject idlobj = lookupIDLName(root, objref);
	return comp.util.getName(spec, idlobj);
    }


    public IDLObject lookupIDLName(IDLObject root, String fullname)
	throws IDLflexException
    {
	IDLObject current = root;
	IDLObject[] list;
	StringTokenizer tok = new StringTokenizer(fullname,":");
	while(tok.hasMoreTokens()) {
	    String s = tok.nextToken();
	    if(s.equals("")) continue;
	    /* Search current for member element named s */
	    list = current.getContentList("MEMBER");
	    int i;
	    for(i=0; i<list.length; i++) {
		if(list[i].getName("name").equals(s)) {
		    current = list[i];
		    break;
		}
	    }
	    if(i>=list.length)
		throw new IDLflexException("Element named "+fullname+" not found");
	}
	return current;
    }


    private static IDLObject getJavaOrbIdlIDLObjects(String idlfile)
	throws IDLflexException
    {
	Repository r = getExternalIR(idlfile);
	return getFromRepository(r);
    }

    private static IDLObject getJavaOrbIorIDLObjects(String ior)
	throws IDLflexException
    {
	Repository r = resolve_ir(ior);
	return getFromRepository(r);
    }


    private static IDLObject getFromRepository(Repository r)
	throws IDLflexException
    {
	IDLObject iobj=null;
	try {
	    iobj = ObjectCreator.get(r);
	} catch(Exception e) {
	    Debug.print(Debug.IDLflex, e);
	    throw new IDLflexException("IDLcompiler: reading from IR "+
				       "repository failed:\n"+
				       e.getMessage());
	}
	return iobj;
    }

    /** Uses IR_JavaORB or IR_ORBacus to automatically create and fill
     *  an interface repository.
     *
     * @exception IDLflexException  if the external interface could not
     *     be started or filled with the IDL data.
     */
    private static Repository getExternalIR( String argsFileName ) 
	throws IDLflexException 
    {
	IRBase irbase=null;
	Repository ir;

	Debug.print(Debug.INFO, Debug.IDLflex,
		    ">> IDLcompiler: Creating interface repository"
		    +" from file "+argsFileName);
	
	try {
	    Class c = Class.forName("org.aspectix.IDLflex.IR_JavaORB");
	    irbase = (IRBase)(c.newInstance());
	    ir = irbase.create_repository( argsFileName );
	    Debug.print(Debug.INFO, Debug.IDLflex, 
			">> IDLcompiler: Using JavaORB Interface Repository");
	    return ir;
	} 
	catch(Throwable e) {
	    e.printStackTrace();
	}
	
	try {
	    Class c = Class.forName("org.aspectix.IDLflex.IR_ORBacus");
	    irbase = (IRBase)(c.newInstance());
	    ir = irbase.create_repository( argsFileName );
	    Debug.print(Debug.INFO, Debug.IDLflex, 
			">> IDLcompiler: Using ORBacus Interface Repository");
	    return ir;
	}
	catch(Throwable e) {
	}
	throw new IDLflexException("Cannot feed "+argsFileName+" to internal repository:\nUnable to use either JavaORB or ORBacus IR tool");
    }



    /** returns a reference to an external interface repository.
     *
     *  if ior_arg is not null, an ORB paramter 
     *  "-ORBservice InterfaceRepository <ior_arg>"
     *  will be passed to the ORB initialization.
     *
     *  Calls orb.resolve_initial_references("InterfaceRepository") to get
     *  the apropriate reference.
     */
    private static Repository resolve_ir(String ior_arg) 
	throws IDLflexException
    {
	throw new IDLflexException("not implemented");
	/*
	String [] args;
	Repository ir;

	// 1. ORB-INIT
	Debug.print(Debug.INFO, Debug.IDLflex,
		    ">> IDLcompiler: Initializing CORBA ORB...");
	if(ior_arg!=null && !ior_arg.equals("")) {
	    ORBArguments.addElement("-ORBservice");
	    ORBArguments.addElement("InterfaceRepository");
	    ORBArguments.addElement(ior_arg);
	}
	args = new String[ORBArguments.size()];
	for(int i=0; i<args.length; i++) {
	    args[i] = (String)ORBArguments.elementAt(i);
	}
	org.omg.CORBA.ORB orb=org.omg.CORBA.ORB.init(args,null);
	
	// 2. Resolve the InterfaceRepository
	Debug.print(Debug.INFO, Debug.IDLflex,
	            ">> IDLflexMain: Resolving the Interface Repository");
	try {
	    obj = orb.resolve_initial_references("InterfaceRepository");
	    ir = org.omg.CORBA.RepositoryHelper.narrow(obj);
	    if(ir==null) throw new org.omg.CORBA.ORBPackage.InvalidName();
	    return ir;
	}
	catch ( org.omg.CORBA.ORBPackage.InvalidName name ) {
	    System.err.println("Unable to resolve the Interface Repository");
	    System.exit(1);
	}
	return null;
	*/
    }


    
    private static IDLObject getFimoIDLObjects(String IDLfile)
	throws IDLflexException
    {
	IDLNode node=null;
	org.aspectix.IDLparser.ValidatingParser parser = 
	    new org.aspectix.IDLparser.ValidatingParser();
	
	if( Debug.verbose(Debug.IDLflex) >= Debug.INFO ) 
	    parser.setVerbose();
	
	try {
	    String preprocess = "gcc -x c++ -E "+IDLflexMain.argsHandon+
	    			" -nostdinc -nostdinc++ -I- -undef";
	    InputStream instream;
	    if(preprocess!=null) {
		for( int i=0; i<IDLflexMain.argsIDLInclude.size(); i++ )
		    preprocess += " -I"+(String)IDLflexMain.argsIDLInclude.elementAt(i);
		Runtime runtime = Runtime.getRuntime();
		Debug.print(Debug.INFO, Debug.IDLflex, "calling "+
			preprocess +" "+ IDLfile);
		Process process = runtime.exec(preprocess +" "+ IDLfile);
		//while(true) { try { process.waitFor(); break; }
		//	catch(InterruptedException ex) {}
		//}
		Debug.print(Debug.INFO, Debug.IDLflex, "Preprocessor terminated");
		final BufferedReader gccerr = new BufferedReader(new InputStreamReader(process.getErrorStream()));
			
		Thread errorcapture = new Thread(){
		
			public void run(){
			    try{
					
				String gccerrline;
				
				if(gccerr.ready() == true){
				    gccerrline = gccerr.readLine();
				    System.out.println("Fehler beim Compiliervorgang!");
				    System.out.println(gccerrline);
				    while(gccerr.ready() == true){
					gccerrline = gccerr.readLine();
					System.out.println(gccerrline);
				    }
				    gccerr.close();
				    System.exit(1);
				};
   
			    }catch (Exception e){}
		    }
		    };
		errorcapture.start();
		    
	       
		instream = process.getInputStream();
	    } else {
		instream = new FileInputStream(IDLfile);
	    }
	    Debug.print(Debug.INFO, Debug.IDLflex, "Preprocessing done, starting parser");
	    node = parser.parse( instream );
	    Debug.print(Debug.INFO, Debug.IDLflex, "Parser returned.");
	    if( Debug.verbose(Debug.IDLflex) >= Debug.INFO ) 
		parser.printTreeInfo();
	} catch (FileNotFoundException e) {
	    throw new IDLflexException("IDLcompiler: file not found: "+
				       IDLfile);
	} catch(java.io.IOException ex) {
	    throw new IDLflexException("IDLcompiler: reading "+IDLfile+
				       " failed:\n"+ex.getMessage());
	} catch(org.aspectix.IDLparser.pub.IDLException ex) {
	    Debug.print(Debug.IDLflex, ex);
	    throw new IDLflexException("IDLcompiler: parsing "+IDLfile+
				       " failed:\n"+ex.getMessage());
	}

	IDLObject iobj=null;
	try {
	    iobj = FimoObjectCreator.get(node);
	    String filename = (new File(IDLfile)).getName();
	    int i = filename.indexOf('.');
	    if(i>0) filename = filename.substring(0,i);
	    // TODO: FIXME: with the following line, the filename
	    // gets included into to IOR, which is wrong.
	    //iobj.setName("name", filename);
	} catch(Exception e) {
	    e.printStackTrace();
	    throw new IDLflexException("IDLcompiler: parsing "+IDLfile+
				       " failed due to these errors:\n"+
				       e.getMessage());
	}
	return iobj;
    }
}
