package org.aspectix.IDLflex;   

import java.io.*;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

/** As Xerces by default just searches for Mapping.dtd in the
 *  current directory, this EntityResolver when lookup up the
 *  DTD file tries a) to find it in the same directory as the
 *  XML docuemnt b) to find it in $(IDLflexHome)/mapping/.
 */
public class IDLflexEntityResolver implements EntityResolver {
    public InputSource resolveEntity(String pubID, String sysID) {
	//System.err.println("resolver... "+sysID);
        if(sysID.endsWith(".dtd")) {
            String fname = (new File(sysID)).getName();
            
            String dtdpath = LocateFile.getDTDSearchPath();
            String file = LocateFile.findFile(fname, dtdpath);
            try {
                return new InputSource(new FileReader(new File(file)));
            }
            catch(Exception e) {
                System.err.println("IBMXMLparser: "+fname+" not found"+
                                   "\n\nDTD search path:\n"+
                                   dtdpath);
            };
        }
        return null;
    }
}
