/*
 * IDLflex -- A flexible, generic code generator for CORBA IDL
 *
 * Copyright (C) 2000  Hans Reiser, AspectIX Research Team
 *                     University of Erlangen-Nuernberg, Germany
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License.
 * The full text of the license can be found in the LICENSE.txt file.
 *
 * $Id: IDLflexException.java,v 1.6 2002/02/26 10:46:10 reiser Exp $
 */

package org.aspectix.IDLflex;

import org.omg.CORBA.*;
import org.w3c.dom.Node;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.aspectix.IDLflex.IRObj.*;

/** Exception thrown for all internal errors of IDLflex. 
 *  The code prints the error message, the current location in the
 *  IDL object representation, and the path through the XML document
 *  which leads to the element which was active when the error occured.
 */
public class IDLflexException extends org.aspectix.AspectixException {
    IDLObject obj;
    IDLObjectVector generatepath;
    Node xmlnode;

    public IDLflexException(String s) {
	super( s );
	generatepath = null;
    }

    public IDLflexException(IDLObjectVector genp, String s) {
	super( constructMessage(s, genp) );
	generatepath = genp;
    }

    public boolean hasContext() {
	return generatepath!=null;
    }

    private static final String constructMessage(String s, 
						 IDLObjectVector path) {
	String a=s;
	
	if(path==null) return a;
	
	// Path to Interface Repository object
	int c = path.count_objects();
	if(c>0) {
	    a=a+"\nCurrent interface repository object: \n";
	    a+=printObjectPath(path);
	}

	// Path in the XML document
	c = path.count_nodes();
	if(c>0) {
	    a=a+"\nPath to the current node in the XML document:\n";
	    a+=printNodePath(path)+"\n";
	}
	return a;
    }

    private static final String printObjectPath(IDLObjectVector v) {
	String path="";
	int cnt=0;
	IDLObject obj;
	try {
	    while( (obj = v.getUpperObject(cnt)) != null ) {
		cnt++;
		String label = obj.getName("name")+" [ "+
		    obj.getName("id")+" ] { " + obj + " } \n";
		path = path + label;
	    }
	    return path;
	} catch(IDLflexException e) {}
	return "";
    }

    private static final String printNodeName(Node n) {
	String s=n.getNodeName();
	try {
	    Element e=(Element)n;
	    NamedNodeMap nm= e.getAttributes();
	    int l=nm.getLength();
	    if(l>0) {
		s+="(";
		for(int i=0; i<l; i++) {
		    Node x = nm.item(i);
		    s+=(i>0?" ":"")+x.getNodeName()+"="+x.getNodeValue();
		}
		s+=")";
	    }
	} catch(Exception e) {}
	return s;
    }

    private static final String printNodePath(IDLObjectVector v) {
	String text = "";
	try {
	    int nodes = v.count_nodes();
	    for(int i=0; i<nodes; i++) {
		Node n = v.nodeAt(i);
		text += printNodeName(n)+"\n";
	    }
	} catch(Exception e) {}

	Node n = v.nodeAt(v.count_nodes()-1);
        text += "\n-----XML path---\n"+printNodeName(n)+"\n";
        try {
            Node dad = n.getParentNode();
            while(dad!=null) {
                n=dad;
                text += printNodeName(n)+"\n";
                dad=n.getParentNode();
            }
        } catch(Exception e) {}
	return text;
    }
}
