/*
 * IDLflex -- A flexible, generic code generator for CORBA IDL
 *
 * Copyright (C) 2000  Hans Reiser, AspectIX Research Team
 *                     University of Erlangen-Nuernberg, Germany
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License.
 * The full text of the license can be found in the LICENSE.txt file.
 *
 * $Id: AliasObj.java,v 1.7 2001/11/09 14:04:28 reiser Exp $
 */

package org.aspectix.IDLflex.IRObj;

import org.aspectix.IDLflex.IDLflexException;


/**	@author Hans Reiser
 *	@version $Id: AliasObj.java,v 1.7 2001/11/09 14:04:28 reiser Exp $
 *
 *	Implementation class for an IDL alias definition.
 */
public class AliasObj extends IDLObject {
    IDLObject base;

    public AliasObj() {
    }

    /**	'BASE' returns the IDL object to which the AliasObj aliases to.
     *  RESOLVE is an alias for BASE and supported for compatibility
     *  reasons. Unknown parameters are forwarded to the base class.
     */
    public IDLObject getContent(String spec) throws IDLflexException {
	if(spec.equalsIgnoreCase("RESOLVE")) return base;
	else if(spec.equalsIgnoreCase("BASE")) return base;
	else return super.getContent(spec);
    }

    public void setContent(String spec, IDLObject content) 
	throws IDLflexException
    {
	if(spec.equalsIgnoreCase("BASE")) base = content;
	else if(spec.equalsIgnoreCase("RESOLVE")) base = content;
	else super.setContent(spec, content);
    }

    public boolean is_a(String spec, boolean inherit) {
	if(spec.equalsIgnoreCase("AliasObj")) return true;
	if(inherit) return super.is_a(spec, inherit);
	else return false;
    }
}

