/*
 * IDLflex -- A flexible, generic code generator for CORBA IDL
 *
 * Copyright (C) 2000  Hans Reiser, AspectIX Research Team
 *                     University of Erlangen-Nuernberg, Germany
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License.
 * The full text of the license can be found in the LICENSE.txt file.
 *
 * $Id: ArrayObj.java,v 1.7 2002/02/14 14:32:39 reiser Exp $
 */

package org.aspectix.IDLflex.IRObj;

import java.lang.Object;
import org.aspectix.IDLflex.IDLflexException;

/** Implementation class for an IDL array.
 */

public class ArrayObj extends IDLObject {
    IDLObject basis;
    int len;

    /**
     */
    public ArrayObj() {
	super( );
    }

    /**	Returns the length of an array for the parameters 'bound' and 'length'.
     *	In the IR, this member is called 'bound' for sequences, 'length' for
     *	arrays. In this object representation, both support both names to
     *	have compatibility between array and sequence for most operations.
     */
    public String getName( String spec ) throws IDLflexException
    {
	spec = spec.toLowerCase();
	if(spec.equals("length")||spec.equals("bound")) return ""+len;
	else return super.getName(spec);
    }

    /**	Returns the same value as {@link #getName(String) getName} for
     *	parameters 'bound' and 'length', just stored as an Integer object
     *	instead of a String. Other parameters are forwarded to base class.
     */
    public Object getValue( String spec ) throws IDLflexException 
    {
	if(spec.equalsIgnoreCase("length")||
	   spec.equalsIgnoreCase("bound")) 
	    return new Integer(len);
	else
	    return super.getValue(spec);
    }

    /** Always returns 'true' for attribute 'bound'. */
    public boolean getAttribute(String spec) throws IDLflexException {
        if(spec.equalsIgnoreCase("bound")) return true;
        else return super.getAttribute(spec);
    }

    /**	Returns the base data type for the array (parameter 'BASE').
     *	For multi-dimensional arrays, this can be another array.
     *	Other parameters are forwarded to base class.
     */
    public IDLObject getContent(String spec) throws IDLflexException {
	if(spec.equalsIgnoreCase("BASE")) return basis;
	else return super.getContent(spec);
    }

    // generic setter methods
    public void setValue(String spec, Object value)
	throws IDLflexException 
    {
        if (spec.equalsIgnoreCase("length") || 
	    spec.equalsIgnoreCase("bound"))
            len = ((Integer) value).intValue();
        else super.setValue(spec, value);
    }
    public void setContent(String spec, IDLObject content) 
	throws IDLflexException 
    {
	if (spec.equalsIgnoreCase("BASE")) basis = content;
        else super.setContent(spec, content);
    }


    /**
     */
    public boolean is_a(String spec, boolean inherit) {
	if(spec.equalsIgnoreCase("ArrayObj")) return true;
	if(inherit) return super.is_a(spec, inherit);
	else return false;
    }
}

