/*
 * IDLflex -- A flexible, generic code generator for CORBA IDL
 *
 * Copyright (C) 2000  Hans Reiser, AspectIX Research Team
 *                     University of Erlangen-Nuernberg, Germany
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License.
 * The full text of the license can be found in the LICENSE.txt file.
 *
 * $Id: AttributeObj.java,v 1.7 2001/11/13 12:28:46 reiser Exp $
 */

package org.aspectix.IDLflex.IRObj;

import org.aspectix.IDLflex.IDLflexException;


/** Definition class for an attribute of an IDL interface.
 *<ul>
 *  <li><em>getContent("BASE")</em>
 *       returns the base type of the attribute.
 *  <li><em>getAttribute("readonly")</em> 
 *       returns true for readonly attributes.
 *</ul>
 */

public class AttributeObj extends IDLObject {
    IDLObject basis = null;
    boolean is_public;
    boolean is_readonly;

    /**
     */
    public AttributeObj() {
    }

    /**	Returns true if the attribute is readonly on parameter 'readonly',
     *	otherwise false. Other parameters are forwarded to base class.
     */
    public boolean getAttribute(String spec) throws IDLflexException {
	if(spec.equalsIgnoreCase("public")) return is_public;
	else if(spec.equalsIgnoreCase("readonly")) return is_readonly;
	return super.getAttribute(spec);
    }

    /**	Returns the base type of the attributed on parameter 'BASE'.
     *	Other parameters are forwarded to base class.
     */
    public IDLObject getContent(String spec) throws IDLflexException {
	if(spec.equalsIgnoreCase("BASE")) return basis;
	else return super.getContent(spec);
    }


    // generic setter methods
    public void setAttribute(String spec, boolean value) 
	throws IDLflexException 
    {
        if (spec.equalsIgnoreCase("public")) is_public = value;
        else if (spec.equalsIgnoreCase("readonly")) is_readonly = value;
        else super.setAttribute(spec, value);
    }
    public void setContent(String spec, IDLObject content) 
	throws IDLflexException 
    {
        if (spec.equalsIgnoreCase("BASE")) basis = content;
        else super.setContent(spec, content);
    }


    /**
     */
    public boolean is_a(String spec, boolean inherit) {
	if(spec.equalsIgnoreCase("AttributeObj")) return true;
	if(inherit) return super.is_a(spec, inherit);
	else return false;
    }
}
