/*
 * IDLflex -- A flexible, generic code generator for CORBA IDL
 *
 * Copyright (C) 2000  Hans Reiser, AspectIX Research Team
 *                     University of Erlangen-Nuernberg, Germany
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License.
 * The full text of the license can be found in the LICENSE.txt file.
 *
 * $Id: ConstantObj.java,v 1.7 2001/11/15 15:27:04 reiser Exp $
 */

package org.aspectix.IDLflex.IRObj;

import java.lang.Object;
import org.aspectix.IDLflex.IDLflexException;
import org.aspectix.IDLflex.Debug;

/** Class for IDL constants
 */
public class ConstantObj extends IDLObject {
    IDLObject basis;
    Object value;

    /**
     */
    public ConstantObj() {
    }

    /**	Returns the constant value on parameter 'value'. All others
     *	are implemented by
     *	{@link org.aspectix.IDLflex.IRObj.IDLObject#getValue( String )}.
     */
    public Object getValue( String spec ) 
	throws IDLflexException 
    {
	if(spec.equalsIgnoreCase("value")) return value;
	else return super.getValue( spec );
    }

    /**	Returns the base type of the constant on parameter 'BASE'.
     *	All other parameters are implemented by
     *	{@link org.aspectix.IDLflex.IRObj.IDLObject#getContent( String )}.
     */
    public IDLObject getContent(String spec) throws IDLflexException {
	if(spec.equalsIgnoreCase("BASE")) return basis;
	else return super.getContent(spec);
    }


    // generic setter methods
    public void setValue(String spec, Object value) 
	throws IDLflexException 
    {
        if (spec.equalsIgnoreCase("value")) this.value = value;
        else super.setValue(spec, value);
    }
    public void setContent(String spec, IDLObject content) 
	throws IDLflexException 
    {
        if (spec.equalsIgnoreCase("BASE")) basis = content;
        else super.setContent(spec, content);
    }

    /**
     */
    public boolean is_a(String spec, boolean inherit) {
	if(spec.equalsIgnoreCase("ConstantObj")) return true;
	if(inherit) return super.is_a(spec, inherit);
	else return false;
    }
}

