/*
 * IDLflex -- A flexible, generic code generator for CORBA IDL
 *
 * Copyright (C) 2000  Hans Reiser, AspectIX Research Team
 *                     University of Erlangen-Nuernberg, Germany
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License.
 * The full text of the license can be found in the LICENSE.txt file.
 *
 * $Id: ContainerObj.java,v 1.7 2001/11/13 12:28:46 reiser Exp $
 */

package org.aspectix.IDLflex.IRObj;

import org.aspectix.IDLflex.IDLflexException;
import org.aspectix.IDLflex.Debug;
import java.util.Vector;


/** A base class for IDL containers.
 */
public class ContainerObj extends IDLObject {
    Vector members;

    /**
     */
    public ContainerObj() {
	members = new Vector();
    }

    /**	Returns the list of contained members as IDLObject array on
     *	parameter 'MEMBER'. Other parameters are forwarded to base class.
     */
    public IDLObject[] getContentList(String spec) throws IDLflexException {
	if(spec.equalsIgnoreCase("MEMBER")) return VectorToIDLObjects(members);
	else return super.getContentList(spec);
    }


    // generic setter methods
    public void addToContentList(String spec, IDLObject content) 
	throws IDLflexException 
    {
        if(spec.equalsIgnoreCase("MEMBER")) members.addElement(content);
        else super.addToContentList(spec, content);
    }


    /**
     */
    public boolean is_a(String spec, boolean inherit) {
	if(spec.equalsIgnoreCase("ContainerObj")) return true;
	if(inherit) return super.is_a(spec, inherit);
	else return false;
    }

}

