/*
 * IDLflex -- A flexible, generic code generator for CORBA IDL
 *
 * Copyright (C) 2000  Hans Reiser, AspectIX Research Team
 *                     University of Erlangen-Nuernberg, Germany
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License.
 * The full text of the license can be found in the LICENSE.txt file.
 *
 * $Id: EnumMemberObj.java,v 1.7 2002/02/26 10:46:10 reiser Exp $
 */

package org.aspectix.IDLflex.IRObj;

import java.lang.Object;
import org.aspectix.IDLflex.IDLflexException;
import org.aspectix.IDLflex.NameCollisionResolver;

/** Implementation of an IDL enum member.
 */
public class EnumMemberObj extends IDLObject {

    /**	EnumObj where this member belongs to.
     */
    IDLObject parent;

    /**	The enum member's int value.
     */
    int value;

    /**
     */
    public EnumMemberObj() {
    }

    /**	Returns the string value of the enum member on parameter 'value'.
     *	Other parameters are forwarded to base class.
     */
    public String getName(String spec) throws IDLflexException 
    {
	if(spec.equalsIgnoreCase("value")) return ""+value;
	return super.getName(spec);
    }

    /**	Returns the numerical value of the enum member on parameter 'value'.
     *	Other parameters are forwarded to base class.
     */
    public Object getValue(String spec) throws IDLflexException 
    {
	if(spec.equalsIgnoreCase("value")) return new Integer(value);
	return super.getValue(spec);
    }

    /**	Returns the embedding EnumObj for this member on parameter 'SUPER'.
     *	Other parameters are forwarded to base class. 
     */
    public IDLObject getContent(String spec) throws IDLflexException {
	if(spec.equalsIgnoreCase("SUPER")) return parent;
	else return super.getContent(spec);
    }

    // generic setter methods
    public void setValue(String spec, Object value) 
	throws IDLflexException 
    {
        if (spec.equalsIgnoreCase("value")) 
	    this.value = ((Integer) value).intValue();
        else super.setValue(spec, value);
    }

    public void setContent(String spec, IDLObject content) 
	throws IDLflexException 
    {
        if (spec.equalsIgnoreCase("SUPER")) parent = content;
        else super.setContent(spec, content);
    }

    /**
     */
    public boolean is_a(String spec, boolean inherit) {
	if(spec.equalsIgnoreCase("EnumMemberObj")) return true;
	if(inherit) return super.is_a(spec, inherit);
	else return false;
    }


}

