/*
 * IDLflex -- A flexible, generic code generator for CORBA IDL
 *
 * Copyright (C) 2000  Hans Reiser, AspectIX Research Team
 *                     University of Erlangen-Nuernberg, Germany
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License.
 * The full text of the license can be found in the LICENSE.txt file.
 *
 * $Id: EnumObj.java,v 1.7 2002/02/26 10:46:10 reiser Exp $
 */

package org.aspectix.IDLflex.IRObj;

import java.lang.*;
import org.aspectix.IDLflex.IDLflexException;
import org.aspectix.IDLflex.Debug;
import java.util.Vector;
import org.omg.CORBA.Any;

/** Implementation class for an IDL enumeration object.
 *<ul>
 * <li><em>getContentList("MEMBER")</em>
 *     returns a list of all enumeration members
 *</ul>
 */
public class EnumObj extends IDLObject {
    Vector members;

    /**
     */
    public EnumObj() {
	members = new Vector();
    }

    /* What is the correct way to extract an Enum from an Any???
     * JavaORB:
     *   the Interface Repository contains an Object of the specific EnumDef
     *   Type. This object can be extracted using the extract_Object() method.
     *   As its exact type is unknown at compile time, we have to use the java
     *   language reflection to look up the "value" Method in this class
     *   and obtain the integer Enum index that way.
     * ORBacus:
     *   the Interface Repository contains an Integer Object to represent the
     *   Enum value. However, there is now way to extract this value from the
     *   IR!!! This is, no standard way, there is a method value() defined,
     *   but this is not portable. Thus, to let this code compile on standard
     *   ANY definitions, we cannot invoke it directly, but we can try to do
     *   so with the java langauge reflection.
     */
    // converts EnumType in any to an integer...
    public final static int valueFromAny( Any any ) throws IDLflexException {
	java.lang.Object obj;
	try {
	    obj = any.extract_Object();
	} catch(Exception e) {
	    // try to extract Any value for ORBacus
	    // (is there any other way to get Enum value from ORBacus??)
	    try {
		Class c = any.getClass();
		java.lang.reflect.Method m = c.getMethod("value", new Class[0]);
		obj = m.invoke(any, new java.lang.Object[0]);
	    } catch(Exception e2) {
		e.printStackTrace();
		throw new IDLflexException("EnumObj.valueFromAny: failed to "+
					   "extract value from any!\n"+
					   "(tried both JavaORB and ORBacus "+
					   "compatible method!");
	    }
	    Integer i = (Integer)obj;
	    Debug.print(Debug.INFO, Debug.IRO, 
			" valueFromAny: result is "+i.intValue() );
	    return i.intValue();
	}
	// Oje, des schaut furchtbar aus, aber geht wohl ned einfacher...
	try {
	    Class c = obj.getClass();
	    System.err.println("obj="+obj+"  class="+c);
	    java.lang.reflect.Method m = c.getMethod("value", new Class[0]);
	    Integer i = (Integer)(m.invoke(obj, new java.lang.Object[0]));
	    Debug.print(Debug.INFO, Debug.IRO, 
			" valueFromAny: result is "+i.intValue() );
	    return i.intValue();
	} catch(Exception e2) {
	    e2.printStackTrace();
	    throw new IDLflexException("EnumObj.valueFromAny: failed to "+
				       "extract value from any!\n"+
				       "(tried both JavaORB and ORBacus "+
					   "compatible method!");
	}
    }

    /*
    public void init_members() throws IDLflexException {
	super.init_members();
	if(referenceObject!=null) {
	    EnumDef ed = EnumDefHelper.narrow(referenceObject);
	    String[] memlist = ed.members();
	    members = new Vector();
	    for(int i=0; i<memlist.length; i++) {
		IDLObject iobj = new EnumMemberObj(memlist[i], i);
		iobj.init_members();
		((EnumMemberObj)iobj).parent = this;
		iobj.defined_in = this.defined_in;
		members.addElement(iobj);
	    }
	}
    }
    */

    /**	Returns list of enum members on parameter 'MEMBER'. Other parameters
     *	are forwarded to base class.
     */
    public IDLObject[] getContentList(String spec) throws IDLflexException {
	if(spec.equalsIgnoreCase("MEMBER")) return VectorToIDLObjects(members);
	else return super.getContentList(spec);
    }

    // generic setter methods
    public void addToContentList(String spec, IDLObject content)
	throws IDLflexException
    {
        if (spec.equalsIgnoreCase("MEMBER")) members.addElement(content);
        else super.addToContentList(spec, content);
    }

    /**
     */
    public boolean is_a(String spec, boolean inherit) {
	if(spec.equalsIgnoreCase("EnumObj")) return true;
	if(inherit) return super.is_a(spec, inherit);
	else return false;
    }
}

