/*
 * IDLflex -- A flexible, generic code generator for CORBA IDL
 *
 * Copyright (C) 2000  Hans Reiser, AspectIX Research Team
 *                     University of Erlangen-Nuernberg, Germany
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License.
 * The full text of the license can be found in the LICENSE.txt file.
 *
 * $Id: ExceptionObj.java,v 1.6 2001/11/09 14:04:29 reiser Exp $
 */

package org.aspectix.IDLflex.IRObj;

import org.aspectix.IDLflex.IDLflexException;
import java.util.Vector;


/** Implemenation class for an IDL exception.
 */
public class ExceptionObj extends ContainerObj {
    Vector elements;

    /**
     */
    public ExceptionObj() {
	elements = new Vector();
    }

    /**	Returns the list of exception elements on parameter 'ELEMENTS' (similar
     *	to IDL structs). Other parameters are forwarded to base class.
     */
    public IDLObject[] getContentList(String spec) throws IDLflexException {
	if(spec.equalsIgnoreCase("ELEMENTS")) return VectorToIDLObjects(elements);
	else return super.getContentList(spec);
    }


    public void addToContentList(String spec, IDLObject content) 
	throws IDLflexException
    {
        if (spec.equalsIgnoreCase("ELEMENTS")) elements.addElement(content);
        else super.addToContentList(spec, content);
    }


    /**
     */
    public boolean is_a(String spec, boolean inherit) {
	if(spec.equalsIgnoreCase("ExceptionObj")) return true;
	if(inherit) return super.is_a(spec, inherit);
	else return false;
    }
}

