/*
 * IDLflex -- A flexible, generic code generator for CORBA IDL
 *
 * Copyright (C) 2000  Hans Reiser, AspectIX Research Team
 *                     University of Erlangen-Nuernberg, Germany
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License.
 * The full text of the license can be found in the LICENSE.txt file.
 *
 * $Id: FixedObj.java,v 1.6 2001/11/09 14:04:29 reiser Exp $
 */

package org.aspectix.IDLflex.IRObj;

import java.lang.Object;
import org.aspectix.IDLflex.IDLflexException;


/** Implementation object for an IDL Fixed numbaer
 */
public class FixedObj extends IDLObject {
    private int digits;
    private int scale;

    /**
     */
    public FixedObj() {
    }
    
    /**	Returns number of digits and scale as a string on parameters
     *	'digits' and 'scale'. Other parameters are forwarded to base class.
     */
    public String getName(String spec) throws IDLflexException
    {
	if(spec.equalsIgnoreCase("digits")) return ""+digits;
	if(spec.equalsIgnoreCase("scale")) return ""+scale;
	return super.getName(spec);
    }

    /**	Returns number of digits and scale as an Integer object on parameters
     *	'digits' and 'scale'. Other parameters are forwarded to base class.
     */
    public Object getValue(String spec)	throws IDLflexException 
    {
	if(spec.equalsIgnoreCase("digits")) return new Integer(digits);
	if(spec.equalsIgnoreCase("scale")) return new Integer(scale);
	return super.getValue(spec);
    }

    // generic setter methods
    public void setValue(String spec, Object value) 
	throws IDLflexException 
    {
        if (spec.equalsIgnoreCase("digits")) 
	    digits = ((Integer) value).intValue();
        else if (spec.equalsIgnoreCase("scale")) 
	    scale = ((Integer) value).intValue();
        else super.setValue(spec, value);
    }


    /**
     */
    public boolean is_a(String spec, boolean inherit) {
	if(spec.equalsIgnoreCase("FixedObj")) return true;
	if(inherit) return super.is_a(spec, inherit);
	else return false;
    }

}

