/*
 * IDLflex -- A flexible, generic code generator for CORBA IDL
 *
 * Copyright (C) 2000  Hans Reiser, AspectIX Research Team
 *                     University of Erlangen-Nuernberg, Germany
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License.
 * The full text of the license can be found in the LICENSE.txt file.
 *
 * $Id: InterfaceObj.java,v 1.8 2002/02/13 15:30:25 reiser Exp $
 */

package org.aspectix.IDLflex.IRObj;

import java.util.Vector;
import org.aspectix.IDLflex.IDLflexException;

/* Implementation class for an IDL Interface.
 *<ul>
 * <li><em>getContentList("BASE")</em>
 *     returns all base classes from which this class inherits directly
 * <li><em>getContentList("ALLBASE")</em>
 *     returns all (direct and indirect) base classes
 * <li><em>getContentList("MEMBER")</em>
 *     returns all elements defined explicitly inside this interface
 * <li><em>getContentList("ALLMEMBER")</em>
 *     returns all member elements, including the inherited ones
 *</ul>
 */
public class InterfaceObj extends IDLObject {
    Vector allBaseInterfaces;
    Vector baseInterfaces;
    Vector members;
    Vector allMembers;  // include inherited objects;
    boolean abstractif;
    boolean localif;

    public InterfaceObj() {
	baseInterfaces = new Vector();
	allBaseInterfaces = new Vector();
	members = new Vector();
	allMembers = new Vector();
    }

    public boolean getAttribute( String spec ) throws IDLflexException {
	if(spec.equalsIgnoreCase("abstractif")) return abstractif;
	else if(spec.equalsIgnoreCase("abstract")) return abstractif;
	else if(spec.equalsIgnoreCase("local")) return localif;
	return super.getAttribute( spec );
    }
    public IDLObject getContent(String spec) throws IDLflexException {
	return super.getContent(spec);
    }

    public IDLObject[] getContentList(String spec) throws IDLflexException {
	if(spec.equalsIgnoreCase("BASE")) 
	    return VectorToIDLObjects(baseInterfaces);
	else if(spec.equalsIgnoreCase("ALLBASE")) 
	    return VectorToIDLObjects(allBaseInterfaces);
	else if(spec.equalsIgnoreCase("MEMBER")) 
	    return VectorToIDLObjects(members);
	else if(spec.equalsIgnoreCase("ALLMEMBER")) 
	    return VectorToIDLObjects(allMembers);
	else 
	    return super.getContentList(spec);
    }

    // generic setter methods
    public void setAttribute(String spec, boolean attribute) 
	throws IDLflexException
    {
        if (spec.equalsIgnoreCase("abstractif")) abstractif = attribute;
        else if (spec.equalsIgnoreCase("abstract")) abstractif = attribute;
        else if (spec.equalsIgnoreCase("local")) localif = attribute;
        else super.setAttribute(spec, attribute);
    }
    

    public void addToContentList(String spec, IDLObject content)
	throws IDLflexException 
    {
        if (spec.equalsIgnoreCase("BASE")) {
            baseInterfaces.addElement(content);
	    
	    if(!allBaseInterfaces.contains(content))
		allBaseInterfaces.add(content);
            IDLObject[] baseList = content.getContentList("ALLBASE");
            for (int i = 0; i < baseList.length; i++) {
		if(!allBaseInterfaces.contains(baseList[i]))
		    allBaseInterfaces.addElement(baseList[i]);
            }
        }
        else if (spec.equalsIgnoreCase("ALLBASE")) {
	    // sollte ned passiern, BASE setzt ALLBASE automatisch!
	    System.err.println("InterfaceObj: WARNING: addToContentList "+
			       "called with ALLBASE argument!\n");
	    allBaseInterfaces.addElement(content);
	}
        else if (spec.equalsIgnoreCase("MEMBER")) {
            members.addElement(content);
	    // Fixed: ObjectCreator erzeugt ALLMEMBER selbst...
	    // TODO: DAS IST MUELL!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
	    // TODO: In ALLMEMBER sollen ALLE AUS BASISKLASSEN GEERBTEN 
	    //       Methoden rein, d.h. ALLMEMBER kann ich mir dann
	    //       zusammenbauen, wenn ich alle Basisklassen kenne.
            //if (content.is_a("InterfaceObj")) {
            //   IDLObject[] memberList = content.getContentList("allmember");
            //    for (int i = 0; i < memberList.length; i++) {
            //        allMembers.addElement(memberList[i]);
            //    }
	    // }
        }
        else if (spec.equalsIgnoreCase("ALLMEMBER")) {
	    allMembers.addElement(content);
	}
        else super.addToContentList(spec, content);
    }    


    /**
     */
    public boolean is_a(String spec, boolean inherit) {
	spec = spec.toLowerCase();
	if(spec.equalsIgnoreCase("interfaceobj")) return true;
	if(inherit) return super.is_a(spec, inherit);
	else return false;
    }
}

