/*
 * IDLflex -- A flexible, generic code generator for CORBA IDL
 *
 * Copyright (C) 2000  Hans Reiser, AspectIX Research Team
 *                     University of Erlangen-Nuernberg, Germany
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License.
 * The full text of the license can be found in the LICENSE.txt file.
 *
 * $Id: OperationObj.java,v 1.5 2001/11/09 14:04:30 reiser Exp $
 */

package org.aspectix.IDLflex.IRObj;

import org.aspectix.IDLflex.IDLflexException;
import java.util.Vector;

/** implementation class for an IDL operation
 *<ul>
 * <li><em>getContent("RETURN")</em>
 *     returns a reference to the return data type
 * <li><em>getContentList("EXCEPT")</em>
 *     returns a list of exceptions thrown by this operation
 * <li><em>getContentList("PARAM")</em>
 *     returns a list of parameters of this operation
 *</ul>
 */
public class OperationObj extends IDLObject {
    //TODO (alnerlic) "CONTEXT" gibts hier noch ned
    boolean oneway;
    Vector param; 
    Vector except;
    IDLObject ret;
    public OperationObj() {
	param = new Vector();
	except = new Vector();
    }

    /*
    public void init_members() throws IDLflexException {
	super.init_members();
	if(referenceObject!=null) {
	    OperationDef opd = OperationDefHelper.narrow(referenceObject);

	    // set param
	    ParameterDescription[] pd = opd.params();
	    param = new IDLObject[pd.length];
	    for(int i=0; i<pd.length; i++) {
		param[i] = new ParameterObj(pd[i]);
		param[i].init_members();
		//param[i].parent = this;
	    }
	    
	    // set except
	    ExceptionDef[] ex = opd.exceptions();
	    except = new IDLObject[ex.length];
	    for(int i=0; i<ex.length; i++) {
		except[i] = ObjectCreator.get(ex[i]);
		// except[i].parent = this;
	    }
	    
	    // set return
	    //System.err.println("result: "+opd.result());
	    //System.err.println("result_def: "+fullname+" "+opd.result_def());
	    ret = ObjectCreator.get( opd.result_def() );
	}
    }
    */

    // generic getter methods
    public boolean getAttribute(String spec) 
	throws IDLflexException 
    {
        if (spec.equals("oneway")) return oneway;
        return super.getAttribute(spec);
    }
    public IDLObject getContent(String spec) throws IDLflexException {
	if(spec.equalsIgnoreCase("RETURN")) return ret;
	else return super.getContent(spec);
    }
    public IDLObject[] getContentList(String spec) throws IDLflexException {
	if(spec.equalsIgnoreCase("PARAM")) 
	    return VectorToIDLObjects(param);
	else if(spec.equalsIgnoreCase("EXCEPT")) 
	    return VectorToIDLObjects(except);
	else return super.getContentList(spec);
    }

    // generic setter methods
    public void setAttribute(String spec, boolean value) 
	throws IDLflexException 
    {
        if (spec.equals("oneway")) oneway = value;
        else super.setAttribute(spec, value);
    }

    public void setContent(String spec, IDLObject content) 
	throws IDLflexException 
    {
        if (spec.equalsIgnoreCase("RETURN")) ret = content;
        else super.setContent(spec, content);
    }

    public void addToContentList(String spec, IDLObject content)
	throws IDLflexException 
    {
        if (spec.equalsIgnoreCase("PARAM")) {
            param.addElement(content);
	} else if(spec.equalsIgnoreCase("EXCEPT")) {
	    except.addElement(content);
	} else
	    super.addToContentList(spec, content);
    }
  
    public boolean is_a(String spec, boolean inherit) {
	if(spec.equalsIgnoreCase("OperationObj")) return true;
	if(inherit) return super.is_a(spec, inherit);
	else return false;
    }
}
