/*
 * IDLflex -- A flexible, generic code generator for CORBA IDL
 *
 * Copyright (C) 2000  Hans Reiser, AspectIX Research Team
 *                     University of Erlangen-Nuernberg, Germany
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License.
 * The full text of the license can be found in the LICENSE.txt file.
 *
 * $Id: ParameterObj.java,v 1.6 2001/11/13 12:28:46 reiser Exp $
 */

package org.aspectix.IDLflex.IRObj;

import org.omg.CORBA.*;
import org.aspectix.IDLflex.IDLflexException;

/** implementation class for an IDL operation paramter
 *<ul>
 * <li><em>getAttribute("inarg"/"outarg"/"inoutarg")</em>
 *     returns true on one of the three possibilities, depending on the
 *     direction of the paramter.
 * <li><em>getContent("BASE")</em>
 *     returns the base type of the paramter
 *</ul>
 */
public class ParameterObj extends IDLObject {
    IDLObject base;
    boolean in;
    boolean out;

    org.omg.CORBA.ParameterMode mode;

    public ParameterObj(  ) {
    }

    public boolean getAttribute( String spec ) throws IDLflexException {
	if(spec.equalsIgnoreCase("inarg")) return (in && !out);
	else if(spec.equalsIgnoreCase("outarg")) return (!in && out);
	else if(spec.equalsIgnoreCase("inoutarg")) return (in && out);
	return super.getAttribute( spec );
    }

    public IDLObject getContent(String spec) throws IDLflexException {
	if(spec.equalsIgnoreCase("BASE")) return base;
	else return super.getContent(spec);
    }

    // generic setter methods
    public void setAttribute(String spec, boolean attribute) 
	throws IDLflexException
    {
        if (spec.equalsIgnoreCase("inarg") && attribute) {
            in = true; out = false;
        } else if (spec.equalsIgnoreCase("outarg") && attribute) {
            in = false; out = true;
        } else if (spec.equalsIgnoreCase("inoutarg") && attribute) {
            in = true;  out = true;
        } else super.setAttribute(spec, attribute);
    }
    public void setContent(String spec, IDLObject content) 
	throws IDLflexException 
    {
        if (spec.equalsIgnoreCase("BASE")) base = content;
        else super.setContent(spec, content);
    }

    public boolean is_a(String spec, boolean inherit) {
	if(spec.equalsIgnoreCase("ParameterObj")) return true;
	if(inherit) return super.is_a(spec, inherit);
	else return false;
    }
}
