/*
 * IDLflex -- A flexible, generic code generator for CORBA IDL
 *
 * Copyright (C) 2000  Hans Reiser, AspectIX Research Team
 *                     University of Erlangen-Nuernberg, Germany
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License.
 * The full text of the license can be found in the LICENSE.txt file.
 *
 * $Id: PrimitiveObj.java,v 1.5 2001/11/09 14:04:30 reiser Exp $
 */

package org.aspectix.IDLflex.IRObj;

import org.aspectix.IDLflex.IDLflexException;

/** implementation object which represents the primitive IDL data
 *  types. 
 */
public class PrimitiveObj extends IDLObject {
    public int TCKindValue;
    public PrimitiveObj() {
	//PrimitiveDef pd = PrimitiveDefHelper.narrow(iro);
	//TCKindValue = pd.type().kind().value();
    }

    public boolean getAttribute(String spec) throws IDLflexException {
	if(!spec.startsWith("tk")) return super.getAttribute(spec);
	return spec.equalsIgnoreCase(name);
    }

    public Object getValue(String spec) throws IDLflexException {
	if(spec.equalsIgnoreCase("tckind")) return new Integer(TCKindValue);
	else return super.getValue(spec);
    }

    public void setValue(String spec, Object value) throws IDLflexException {
	if(spec.equalsIgnoreCase("tckind")) 
	    TCKindValue = ((Integer)value).intValue();
	else super.setValue(spec, value);
    }

    public boolean is_a(String spec, boolean inherit) {
	if(spec.equalsIgnoreCase("PrimitiveObj")) return true;
	if(inherit) return super.is_a(spec, inherit);
	else return false;
    }
}
