/*
 * IDLflex -- A flexible, generic code generator for CORBA IDL
 *
 * Copyright (C) 2000  Hans Reiser, AspectIX Research Team
 *                     University of Erlangen-Nuernberg, Germany
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License.
 * The full text of the license can be found in the LICENSE.txt file.
 *
 * $Id: SequenceObj.java,v 1.6 2001/11/09 14:04:30 reiser Exp $
 */

package org.aspectix.IDLflex.IRObj;

import java.lang.Object;
import org.aspectix.IDLflex.IDLflexException;

/** implementation class for an IDL sequence.
 *<ul>
 * <li><em>getContent("BASE")</em>
 *     returns the base data type for the sequence. For multidimensional
 *     sequences, this can be another sequence.
 * <li><em>getName("bound"),getName("length")</em>
 *     returns the bound of a sequence. In the IR, this member is called
 *     "bound" for sequences, "length" for arrays. In this object 
 *     representation, both support both names, to have compatibility
 *     between array and sequence for most operations.
 * <li><em>getValue("bound"),getName("length")</em>
 *     returns the same value as getName, just stored as an Integer object,
 *     instead of as a String.
 *</ul>
 */
public class SequenceObj extends IDLObject {
    IDLObject base;
    int bound;

    public SequenceObj() {
    }

    public String getName(String spec) throws IDLflexException
    {
	if(spec.equalsIgnoreCase("bound")||
	   spec.equalsIgnoreCase("length"))
	    return ""+bound;
	return super.getName(spec);
    }

    public Object getValue(String spec) throws IDLflexException
    {
	if(spec.equalsIgnoreCase("bound")||
	   spec.equalsIgnoreCase("length")) 
	    return new Integer(bound);
	return super.getValue(spec);
    }

    public IDLObject getContent(String spec) throws IDLflexException {
	if(spec.equalsIgnoreCase("base")) return base;
	else return super.getContent(spec);
    }

    public boolean getAttribute(String spec) throws IDLflexException {
	if(spec.equalsIgnoreCase("bound")) return (bound>0);
	else return super.getAttribute(spec);
    }

    // generic setter methods
    public void setValue(String spec, Object value) 
	throws IDLflexException 
    {
        if (spec.equalsIgnoreCase("bound") || 
	    spec.equalsIgnoreCase("length"))
            bound = ((Integer) value).intValue();
        else super.setValue(spec, value);
    }
    public void setContent(String spec, IDLObject content) 
	throws IDLflexException 
    {
        if (spec.equalsIgnoreCase("BASE")) base = content;
        else super.setContent(spec, content);
    }

    public boolean is_a(String spec, boolean inherit) {
	if(spec.equalsIgnoreCase("SequenceObj")) return true;
	if(inherit) return super.is_a(spec, inherit);
	else return false;
    }
}
