/*
 * IDLflex -- A flexible, generic code generator for CORBA IDL
 *
 * Copyright (C) 2000  Hans Reiser, AspectIX Research Team
 *                     University of Erlangen-Nuernberg, Germany
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License.
 * The full text of the license can be found in the LICENSE.txt file.
 *
 * $Id: StringObj.java,v 1.5 2001/11/09 14:04:30 reiser Exp $
 */

package org.aspectix.IDLflex.IRObj;

import java.lang.Object;
import org.omg.CORBA.*;
import org.aspectix.IDLflex.IDLflexException;

/** definition class for an IDL string. The internal IDL representation uses
 *  this class for all kinds of strings (wide/normal, bound/unbount).
 *<ul>
 * <li><em>getAttribute("bound")</em>
 *     is true for bound strings
 * <li><em>getAttribute("wide")</em>
 *     is true for wide strings (bound or unbound)
 * <li><em>getName("bound")/getValue("bound")</em>
 *     returns the bound of the string (-1 for unbound string), either
 *     as numerical string, or as Interger object.
 *</ul>
 */
public class StringObj extends IDLObject {
    boolean is_bound;
    boolean is_wide;
    int bound;

    public StringObj() {
    }

    public boolean getAttribute(String spec) throws IDLflexException {
	if(spec.equalsIgnoreCase("bound")) return is_bound;
	else if(spec.equalsIgnoreCase("wide")) return is_wide;
	return super.getAttribute(spec);
    }

    public String getName(String spec) throws IDLflexException
    {
	if(spec.equalsIgnoreCase("bound")) return ""+bound;
	else return super.getName(spec);
    }
    
    public Object getValue(String spec) throws IDLflexException 
    {
	if(spec.equalsIgnoreCase("bound")) return new Integer( bound );
	else return super.getValue(spec);
    }

    // generic setter methods
    public void setAttribute(String spec, boolean attribute) 
	throws IDLflexException
    {
        if (spec.equalsIgnoreCase("bound")) is_bound = attribute;
        else if (spec.equalsIgnoreCase("wide")) is_wide = attribute;
        else super.setAttribute(spec, attribute);
    }

    public void setValue(String spec, Object value) 
	throws IDLflexException 
    {
        if (spec.equalsIgnoreCase("bound")) {
            bound = ((Integer) value).intValue();
            is_bound = true;
        } else super.setValue(spec, value);
    }

    public boolean is_a(String spec, boolean inherit) {
	if(spec.equalsIgnoreCase("StringObj")) return true;
	if(inherit) return super.is_a(spec, inherit);
	else return false;
    }
}
