/*
 * IDLflex -- A flexible, generic code generator for CORBA IDL
 *
 * Copyright (C) 2000  Hans Reiser, AspectIX Research Team
 *                     University of Erlangen-Nuernberg, Germany
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License.
 * The full text of the license can be found in the LICENSE.txt file.
 *
 * $Id: StructMemberObj.java,v 1.5 2001/11/09 14:04:30 reiser Exp $
 */

package org.aspectix.IDLflex.IRObj;

import org.omg.CORBA.*;
import org.aspectix.IDLflex.IDLflexException;

/* implementation class for an struct member.
 *<ul>
 * <li><em>getContent("BASE")</em> 
 *     returns the base type of this struct component
 *</ul>
 */
public class StructMemberObj extends IDLObject {
    IDLObject type;

    public StructMemberObj() {
    }

    public IDLObject getContent(String spec) throws IDLflexException {
	if(spec.equalsIgnoreCase("BASE")) return type;
	else return super.getContent(spec);
    }

    // generic setter methods
    public void setContent(String spec, IDLObject content) 
	throws IDLflexException 
    {
        if (spec.equalsIgnoreCase("BASE")) type = content;
        else super.setContent(spec, content);
    }

    public boolean is_a(String spec, boolean inherit) {
	if(spec.equalsIgnoreCase("StructMemberObj")) return true;
	if(inherit) return super.is_a(spec, inherit);
	else return false;
    }
}
