/*
 * IDLflex -- A flexible, generic code generator for CORBA IDL
 *
 * Copyright (C) 2000  Hans Reiser, AspectIX Research Team
 *                     University of Erlangen-Nuernberg, Germany
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License.
 * The full text of the license can be found in the LICENSE.txt file.
 *
 * $Id: StructObj.java,v 1.5 2001/11/09 14:04:30 reiser Exp $
 */

package org.aspectix.IDLflex.IRObj;

import org.aspectix.IDLflex.IDLflexException;
import java.util.Vector;

/* implementation of an IDL structure
 *<ul>
 * <li><em>getContentList("ELEMENTS")</em>
 *     returns the list of structure member elements
 *</ul>
 */
public class StructObj extends ContainerObj {
    Vector elements;
    public StructObj() {
	elements = new Vector();
    }

    public IDLObject[] getContentList(String spec) throws IDLflexException {
	if(spec.equalsIgnoreCase("ELEMENTS")) 
	    return VectorToIDLObjects(elements);
	else return super.getContentList(spec);
    }

    // generic setter methods
    public void addToContentList(String spec, IDLObject content) 
	throws IDLflexException
    {
        if (spec.equalsIgnoreCase("ELEMENTS")) 
	    elements.addElement(content);
        else super.addToContentList(spec, content);
    }

    public boolean is_a(String spec, boolean inherit) {
	if(spec.equalsIgnoreCase("StructObj")) return true;
	if(inherit) return super.is_a(spec, inherit);
	else return false;
    }
}
