/*
 * IDLflex -- A flexible, generic code generator for CORBA IDL
 *
 * Copyright (C) 2000  Hans Reiser, AspectIX Research Team
 *                     University of Erlangen-Nuernberg, Germany
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License.
 * The full text of the license can be found in the LICENSE.txt file.
 *
 * $Id: UnionMemberObj.java,v 1.6 2001/11/15 15:27:05 reiser Exp $
 */

package org.aspectix.IDLflex.IRObj;

import java.lang.Object;
import org.omg.CORBA.*;
import org.aspectix.IDLflex.IDLflexException;
import java.util.Vector;

/** implementation object for union members
 *<ul>
 * <li><em>getAttribute("unique")</em>
 *         is true, if this entry has just one label
 * <li><em>getAttribute("isdefault")></em>
 *         is true, if this label is the default label
 * <li><em>getValue("discr")</em>
 *         numeric value of discriminator label value stored in Long
 * <li><em>getContent("BASE")</em>
 *         base type of this member entry
 * <li><em>getContent("SUPER")</em>
 *         returns the surrounding UnionObj object
 * <li><em>getContentList("ELEMENTS")</em>
 *         for an UnionObj's CASES(==UNIQUE) list, this ELEMENTS list 
 *         containes all labels for this definition entry
 *</ul>
 */
public class UnionMemberObj extends IDLObject {
    boolean isdef;         // explicit "default:"-Label
    UnionObj dad;          // outer UnionObj
    IDLObject type;        // base type. should be equal dad:"DISCR"
    long label;            // numeric label index.
    Vector labels;         // UnionMemberObj

    public UnionMemberObj() {
	labels = new Vector();
	isdef = false;
    }

    public boolean getAttribute(String spec) throws IDLflexException {
	if(spec.equalsIgnoreCase("unique")) 
	    return (labels==null||labels.size()<=1);
	if(spec.equalsIgnoreCase("isdefault")) return isdef;
	return super.getAttribute(spec);
    }

    public void setAttribute(String spec, boolean val) 
	throws IDLflexException 
    {
	if(spec.equalsIgnoreCase("unique")) 
	    throw new IDLflexException("UnionMemberObj: setting unique attribute does not make sense!");
	else if(spec.equalsIgnoreCase("isdefault"))
	    isdef = val;
	else super.setAttribute(spec, val);
    }

    public String getName(String spec) throws IDLflexException
    {
	if(spec.equalsIgnoreCase("discr")) {
	    return "" + label;
	}
	else return super.getName(spec);
    }

    // TODO: Das taugt wohl noch ned viel...
    public Object getValue(String spec) throws IDLflexException
    {
	if(spec.equalsIgnoreCase("discr")) return new Long(label);
	return super.getValue(spec);
    }

    public void setValue(String spec, Object value) throws IDLflexException {
	if(spec.equalsIgnoreCase("discr")) {
	    label = ((Long)value).longValue();
	}
    }
	
    public IDLObject getContent(String spec) throws IDLflexException {
	if(spec.equalsIgnoreCase("BASE")) return type;
	else if(spec.equalsIgnoreCase("SUPER")) return dad;
	else return super.getContent(spec);
    } 


    public void setContent(String spec, IDLObject val) 
	throws IDLflexException 
    {
	if(spec.equalsIgnoreCase("BASE")) type = val;
	else if(spec.equalsIgnoreCase("SUPER")) dad = (UnionObj)val;
	else super.setContent(spec, val);
    } 

    public IDLObject[] getContentList(String spec) throws IDLflexException {
	if(spec.equalsIgnoreCase("ELEMENTS")) 
	    return VectorToIDLObjects(labels);
	else return super.getContentList(spec);
    }

    public void addToContentList(String spec, IDLObject content)
	throws IDLflexException 
    {
        if (spec.equalsIgnoreCase("ELEMENTS")) 
	    labels.addElement(content);
        else super.addToContentList(spec, content);
    }


    public boolean is_a(String spec, boolean inherit) {
	if(spec.equalsIgnoreCase("UnionMemberObj")) return true;
	if(inherit) return super.is_a(spec, inherit);
	else return false;
    }
}
