/*
 * IDLflex -- A flexible, generic code generator for CORBA IDL
 *
 * Copyright (C) 2002  Hans Reiser, AspectIX Research Team
 *                     University of Erlangen-Nuernberg, Germany
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License.
 * The full text of the license can be found in the LICENSE.txt file.
 *
 * $Id: ValueTypeObj.java,v 1.1 2002/02/13 13:49:43 reiser Exp $
 */

package org.aspectix.IDLflex.IRObj;

import java.util.Vector;
import org.aspectix.IDLflex.IDLflexException;

/**
 * Implementation class for an IDL Value Type.
 *<ul>
 * <li><em>getContentList("BASE")</em>
 *     returns all base value types from which this class inherits directly
 * <li><em>getContentList("ALLBASE")</em>
 *     TODO? returns all (direct and indirect) base value types
 * <li><em>getContentList("SUPPORT")</em>
 *     returns all base interfaces which this class supports directly
 * <li><em>getContentList("ALLSUPPORT")</em>
 *     TODO? returns all (direct and indirect) base interfaces
 * <li><em>getContentList("MEMBER")</em>
 *     returns all elements defined explicitly inside this interface. These
 *     include state definitions, factories (state initializers) and local
 *     operations.
 * <li><em>getContentList("ALLMEMBER")</em>
 *     returns all member elements, including the inherited ones
 *</ul>
 * Attributes: custom, truncatable, boxed, abstract
 */
public class ValueTypeObj extends IDLObject {
    //Vector allBaseInterfaces;
    Vector baseValueTypes;
    Vector supportedInterfaces;
    Vector members;
    Vector allMembers;  // include inherited objects;

    boolean custom;
    boolean truncatable;
    boolean boxed;
    boolean abstractvt;

    public ValueTypeObj() {
	baseValueTypes = new Vector();
	supportedInterfaces = new Vector();
	members = new Vector();
	allMembers = new Vector();
    }

    public boolean getAttribute( String spec ) throws IDLflexException {
	if(spec.equalsIgnoreCase("abstract")) return abstractvt;
	else if(spec.equalsIgnoreCase("custom")) return custom;
	else if(spec.equalsIgnoreCase("boxed")) return boxed;
	else if(spec.equalsIgnoreCase("truncatable")) return truncatable;
	return super.getAttribute( spec );
    }

    public void setAttribute(String spec, boolean attribute) 
	throws IDLflexException
    {
        if (spec.equalsIgnoreCase("abstract")) abstractvt = attribute;
	else if(spec.equalsIgnoreCase("custom")) custom = attribute;
	else if(spec.equalsIgnoreCase("boxed")) boxed = attribute;
	else if(spec.equalsIgnoreCase("truncatable")) truncatable = attribute;
        else super.setAttribute(spec, attribute);
    }
    

    public IDLObject getContent(String spec) throws IDLflexException {
	return super.getContent(spec);
    }

    public IDLObject[] getContentList(String spec) throws IDLflexException {
	if(spec.equalsIgnoreCase("BASE")) 
	    return VectorToIDLObjects(baseValueTypes);
	else if(spec.equalsIgnoreCase("SUPPORTS")) 
	    return VectorToIDLObjects(supportedInterfaces);
	else if(spec.equalsIgnoreCase("MEMBER")) 
	    return VectorToIDLObjects(members);
	else if(spec.equalsIgnoreCase("ALLMEMBER")) 
	    return VectorToIDLObjects(allMembers);
	else 
	    return super.getContentList(spec);
    }

    public void addToContentList(String spec, IDLObject content)
	throws IDLflexException 
    {
        if (spec.equalsIgnoreCase("BASE")) {
            baseValueTypes.addElement(content);
	    /*
	    if(!allBaseInterfaces.contains(content))
		allBaseInterfaces.add(content);
            IDLObject[] baseList = content.getContentList("ALLBASE");
            for (int i = 0; i < baseList.length; i++) {
		if(!allBaseInterfaces.contains(baseList[i]))
		    allBaseInterfaces.addElement(baseList[i]);
            }
	    */
        }
        else if (spec.equalsIgnoreCase("SUPPORTS")) {
	    supportedInterfaces.addElement(content);
	}
        else if (spec.equalsIgnoreCase("MEMBER")) {
            members.addElement(content);
        }
        else if (spec.equalsIgnoreCase("ALLMEMBER")) {
	    allMembers.addElement(content);
	}
        else super.addToContentList(spec, content);
    }    


    /**
     */
    public boolean is_a(String spec, boolean inherit) {
	spec = spec.toLowerCase();
	if(spec.equalsIgnoreCase("ValueTypeObj")) return true;
	if(inherit) return super.is_a(spec, inherit);
	else return false;
    }
}

