package org.aspectix.IDLflex.IRObj.util;

import org.aspectix.IDLflex.IRObj.IDLObject;
import java.util.*;
   

public class IDLIteratorUtil {
    
    public static Iterator create(IDLObject o) { 
        final IDLObject finalObj = o;
        return new Iterator() {
                private IDLObject obj = finalObj;
                
                public boolean hasNext() {
                    if(obj == null) return false;
                    else return true;
                }
                
                public Object next() throws NoSuchElementException {
                    if(obj == null) throw new NoSuchElementException();
                    else {
                        IDLObject ret = obj;
                        obj = null;
                        return ret;
                    }
                }
        
                public void remove() throws UnsupportedOperationException {
                    throw new UnsupportedOperationException();
                }   
            };
    }
    
    public static Iterator concat(Iterator i, Iterator j) {
        final Iterator first = i;
        final Iterator second = j;
        return new Iterator() {
                public boolean hasNext() {
                    if(first.hasNext()) return true;
                    else if(second.hasNext()) return true;
                    else return false;
                }
                
                public Object next() throws NoSuchElementException {
                    if(first.hasNext()) return first.next();
                    else if(second.hasNext()) return second.next();
                    else throw new NoSuchElementException();
                }
                
                public void remove() throws UnsupportedOperationException {
                    throw new UnsupportedOperationException();
                } 
                
            };
    }
    
}
