/*
 * IDLflex -- A flexible, generic code generator for CORBA IDL
 *
 * Copyright (C) 2000  Hans Reiser, AspectIX Research Team
 *                     University of Erlangen-Nuernberg, Germany
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License.
 * The full text of the license can be found in the LICENSE.txt file.
 *
 * $Id: IR_JavaORB.java,v 1.4 2001/09/07 09:20:42 reiser Exp $
 */

package org.aspectix.IDLflex;

import JavaORB.compiler.object.*;
import JavaORB.compiler.parser.*;
import JavaORB.compiler.generator.*;
import JavaORB.ir.*;
import org.omg.CORBA.Repository;

/** JavaORB specific automated creation of the interface repository.
 *  does only compile with JavaORB .jar file.  <br>
 *  Probably this will only work with JavaORB Version 2.2.4.
 */
public class IR_JavaORB implements IRBase {
    /** public method the create the interface repository, and feed
     *  it with the specified file.
     *
     * @exception Throwable  if it failes
     */
    public Repository create_repository( String filename ) 
	throws Throwable
    {
	// Create a new interface Repository and register it with the orb
	// (registration necessary??)
	JavaORB.CORBA.ORBSingleton orb = (JavaORB.CORBA.ORBSingleton )
	JavaORB.CORBA.ORBSingleton.init(new String[0], null);
	IR._boa = orb.BOA_init(new String[0]);
	RepositoryImpl _root = new RepositoryImpl();
	IR._boa.connect(_root,"IRRoot");
	IR._boa.obj_is_ready(_root);
	
	JavaORB.compiler.IdlCompiler.packageName = new String("corba_pkg");
	IdlObject CompilationGraph;
	IdlParser Parser = new IdlParser();
	idlToIR toIR = new idlToIR();
	
	// HAS NO EFFECT WITH JAVAORB2.2.3
	// JavaORB.ir.idlToIR.verbose = false;
	JavaORB.compiler.IdlCompiler.verbose = true;

	// necessary for 2.2.4!
	JavaORB.compiler.IdlCompiler.analyse_arguments( new String[0] );
	JavaORB.compiler.IdlCompiler.map_all = true;
	
	CompilationGraph = Parser.compile_idl( filename );
	if ( Parser.totalError != 0 ) {
	    System.err.println("there are errors in IDL file...");
	    System.err.println("No IDL definitions added !");
	    System.exit(0);
	}
	toIR.addIDLData( CompilationGraph, _root );
	
	return _root;
    }
    public void cleanup() {
    }
}

