/*
 * IDLflex -- A flexible, generic code generator for CORBA IDL
 *
 * Copyright (C) 2000  Hans Reiser, AspectIX Research Team
 *                     University of Erlangen-Nuernberg, Germany
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License.
 * The full text of the license can be found in the LICENSE.txt file.
 *
 * $Id: IR_ORBacus.java,v 1.4 2002/02/26 10:46:10 reiser Exp $
 */

package org.aspectix.IDLflex;

import org.omg.CORBA.Repository;
import org.aspectix.IDLflex.IDLflexMain;
import java.io.*;

/** ORBacus specific creating and feeding of the interface repository.
 *  This will compile with any CORBA implemenattion; however the ORBacus
 *  tool "irserv" must be accessible through PATH.
 *
 *  This function executes the external IR, automatically extracts the
 *  IOR from its stdout, and uses this for ORB initialization.
 */
public class IR_ORBacus implements IRBase {
    static private Process killproc = null;

    public Repository create_repository( String filename ) {
	String refid;
	try {
	    String[] irserv = new String[3];
	    irserv[0] = "irserv";
	    irserv[1] = "--ior";
	    irserv[2] = filename;
	    killproc = java.lang.Runtime.getRuntime().exec(irserv);
	    InputStream is = killproc.getInputStream();
	    InputStream es = killproc.getErrorStream();

	    byte[] idbytes = new byte[1024];
	    while(true) {
		int len = is.read(idbytes);
		if(len>0) {
		    refid = new String(idbytes,0,len<0?1024:len);
		    refid = refid.trim();
		    break;
		}
		if(len<0) {
		    // process died -- end of input stream...
		    while(true) {
			len = es.read(idbytes);
			if(len>0) {
			    String errstr = new String(idbytes,0,len<0?1024:len);
			    System.err.print(errstr);
			}
			if(len<0) System.exit(1);
		    }
		}
	    }
	    int len;
	    while( (len=es.available())>0) {
		byte[] msg = new byte[len];
		int l = es.read(msg);
		System.err.print(new String(msg,0,l));
	    }
		// System.err.println("refid is: **"+refid+"**");
		return resolve_ir(refid);
	}
	catch(Exception e) {
	    e.printStackTrace();
	    System.exit(1);
	    return null;
	}

    }
    
	/** returns a reference to an external interface repository.
	  *
	  *  if ior_arg is not null, an ORB paramter 
	  *  "-ORBservice InterfaceRepository <ior_arg>"
	  *  will be passed to the ORB initialization.
	  *
	  *  Calls orb.resolve_initial_references("InterfaceRepository") to get
	  *  the apropriate reference.
	  */
	 private static Repository resolve_ir(String ior_arg) 
	 throws IDLflexException
	 {
	 throw new IDLflexException("not implemented");
	 /*
	 String [] args;
	 Repository ir;

	 // 1. ORB-INIT
	 Debug.print(Debug.INFO, Debug.IDLflex,
			 ">> IDLcompiler: Initializing CORBA ORB...");
	 if(ior_arg!=null && !ior_arg.equals("")) {
		 ORBArguments.addElement("-ORBservice");
		 ORBArguments.addElement("InterfaceRepository");
		 ORBArguments.addElement(ior_arg);
	 }
	 args = new String[ORBArguments.size()];
	 for(int i=0; i<args.length; i++) {
		 args[i] = (String)ORBArguments.elementAt(i);
	 }
	 org.omg.CORBA.ORB orb=org.omg.CORBA.ORB.init(args,null);
	
	 // 2. Resolve the InterfaceRepository
	 Debug.print(Debug.INFO, Debug.IDLflex,
				 ">> IDLflexMain: Resolving the Interface Repository");
	 try {
		 obj = orb.resolve_initial_references("InterfaceRepository");
		 ir = org.omg.CORBA.RepositoryHelper.narrow(obj);
		 if(ir==null) throw new org.omg.CORBA.ORBPackage.InvalidName();
		 return ir;
	 }
	 catch ( org.omg.CORBA.ORBPackage.InvalidName name ) {
		 System.err.println("Unable to resolve the Interface Repository");
		 System.exit(1);
	 }
	 return null;
	 */
	 }
	 
    public void cleanup() {
	if(killproc!=null) {
	    killproc.destroy();
	    killproc=null;
	    Debug.print(Debug.INFO, Debug.IDLflex, 
			">> IR_ORBacus: Killing irserv");
	}
    }
}
