package org.aspectix.IDLflex;

import java.util.Hashtable;
import java.util.Vector;
import java.util.StringTokenizer;
import java.util.Enumeration;
import java.io.File;

public class LocateFile {
    static Hashtable parsedPath = new Hashtable();

    public static String findFile(String filename, String searchpath) {
	if(filename.startsWith("/")) return filename;

	searchpath = searchpath.intern();
	Vector path = (Vector)parsedPath.get(searchpath);
	if(path==null) {
	    path = new Vector();
	    StringTokenizer st = new StringTokenizer(searchpath, ":");
	    while(st.hasMoreElements()) {
		String s = (String)st.nextElement();
		if(!s.equals("")) {
		    path.add(s);
		}
	    }
	    parsedPath.put(searchpath, path);
	}
	Enumeration en = path.elements();
	while(en.hasMoreElements()) {
	    String vpath = (String)en.nextElement() + "/";
	    String file = vpath+filename;
	    if ( (new File(file)).exists() ) {
		return file;
	    }
	}
	return null;
    }

    public static String getXMLSearchPath() {
	String xmlpath = System.getProperty("IDLflexXMLPATH");
	//String xmlpath = org.aspectix.AspectixEnvironment.MAP_DIR;
	if(xmlpath!=null)
	    return xmlpath;
	
	// For compatibility with earlier versions:
	// String home = System.getProperty("IDLflexHome", ".");
	//return home+"/mapping:"+home;
	return ".";
    }

    public static String getDTDSearchPath() {
	String dtdpath = System.getProperty("IDLflexDTDPATH");
	//String dtdpath = org.aspectix.AspectixEnvironment.DTD_DIR;
	if(dtdpath!=null) 
	    return dtdpath;
	else
	    return getXMLSearchPath();
    }
}
