/*
 * IDLflex -- A flexible, generic code generator for CORBA IDL
 *
 * Copyright (C) 2000  Hans Reiser, AspectIX Research Team
 *                     University of Erlangen-Nuernberg, Germany
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License.
 * The full text of the license can be found in the LICENSE.txt file.
 *
 * $Id: NameCollisionResolver.java,v 1.2 2000/12/15 15:32:26 fzhauck Exp $
 */

package org.aspectix.IDLflex;

/** This a auxiliar class which can be used to resolve name collisions.
 *  
 *  It supports two types of name collistion resolving:
 *<ul>
 *  <li> a list of reserved names can be specified, to which an underscore
 *       will be put in front.
 *  <li> a list of reserved suffixes can be specified. A name is scanned
 *       for such suffixes, and for each suffix found, an underscore is
 *       put in front of the complete name.
 *</ul>
 */
public class NameCollisionResolver {
    String[] suffix;
    String[] reserved;
    /** The constructur initializes the suffix and reserved word list.
     *  One of them may be empty (null).
     */
    public NameCollisionResolver(String[] suffix, String[] reserved) {
	this.suffix=suffix;
	this.reserved = reserved;
    }
    /** This function performs the name collision resolving for the
     *  specified string.
     */
    public String resolve(String s) {
	String worker = s;
	int clashcnt = 0;
	int i;
	if(suffix!=null) {
	loop:
	    while(true) {
		for(i=0; i<suffix.length; i++) {
		    if( worker.endsWith(suffix[i]) ) {
			worker = worker.substring(0, worker.length()-suffix[i].length() );
			clashcnt++;
			continue loop;
		    }
		}
		break loop;
	    }
	}

	if(reserved!=null) {
	    for(i=0; i<reserved.length; i++) {
		if( worker.equals(reserved[i]) ) {
		    clashcnt++;
		}
	    }
	}

	for(i=0; i<clashcnt; i++) { s="_"+s;}
	return s;
    }
}
    
