/*
 * IDLflex -- A flexible, generic code generator for CORBA IDL
 *
 * Copyright (C) 2000  Hans Reiser, AspectIX Research Team
 *                     University of Erlangen-Nuernberg, Germany
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License.
 * The full text of the license can be found in the LICENSE.txt file.
 *
 * $Id: Plugin.java,v 1.1 2001/09/07 09:20:42 reiser Exp $
 */

package org.aspectix.IDLflex;

import java.lang.Object;
import org.aspectix.IDLflex.IRObj.IDLObject;

/** Abstract base class for 'Plugin' objects.
 * 
 *  These objects have the same interface as an IDLObject, thus can be
 *  used for name replacement, iteration, and condition checking.
 *  furthermore, a Plugin object can execute commands.
 */
abstract public class Plugin extends IDLObject {
    public String name;
    public Plugin() {
    }
    public String getName(String spec) throws IDLflexException {
	return "";
    };
    public IDLObject[] getContentList(String spec) throws IDLflexException {
	return new IDLObject[0];
    }
    public boolean getAttribute(String spec) throws IDLflexException {
	return false;
    }
    public void execCmd(String spec) throws IDLflexException {
    }
}
