/*
 * IDLflex -- A flexible, generic code generator for CORBA IDL
 *
 * Copyright (C) 2000  Hans Reiser, AspectIX Research Team
 *                     University of Erlangen-Nuernberg, Germany
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License.
 * The full text of the license can be found in the LICENSE.txt file.
 *
 * $Id: SaveBox.java,v 1.2 2000/12/15 15:32:26 fzhauck Exp $
 */

package org.aspectix.IDLflex;

import java.util.Vector;

/** The internal implementation of Save-Boxes, which supports insertion
 *  of named entries, retrieval of the data corresponding to a name,
 *  and the deletion of named entries
 */
public class SaveBox {
    protected Vector v;
    public SaveBox() {
        v = new Vector();	
    }
    public void put(String tag, String data) {
	String[] s = new String[2];
	s[0]=tag; s[1]=data;
	v.addElement( s );
    }
    public String get(String tag) {
	for(int i=v.size()-1; i>=0; i--) {
	    String[] st = (String[])(v.elementAt(i));
	    if( st[0].equals(tag) ) return st[1];
	}
	System.err.println("SaveBox: Tag "+tag+" not found!");
	return "";
    }
    public void del(String tag) {
	for(int i=v.size()-1; i>=0; i--) {
	    String[] st = (String[])(v.elementAt(i));
	    if( st[0].equals(tag) ) v.removeElementAt(i);
	}
    }
}
