/*
 * IDLflex -- A flexible, generic code generator for CORBA IDL
 *
 * Copyright (C) 2000  Hans Reiser, AspectIX Research Team
 *                     University of Erlangen-Nuernberg, Germany
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License.
 * The full text of the license can be found in the LICENSE.txt file.
 *
 * $Id: UtilityResolvedPath.java,v 1.5 2001/11/26 11:12:32 reiser Exp $
 */

package org.aspectix.IDLflex;

import org.omg.CORBA.*;
import java.lang.Object;
import java.util.Vector;
import org.aspectix.IDLflex.IRObj.*;

/** This class is used by the auxiliar resolve() function of the Utility
 *  class. 
 *  It gives access to a Vector of elements, which represent the names and
 *  types of the current object and all surrounding container objects.
 */
public class UtilityResolvedPath {
    public Vector v;
    public UtilityResolvedPath() {
	v = new Vector();
    }

    public UtilityResolvedPath(UtilityResolvedPath p) {
	if(p==null) { v=new Vector(); }
	else v=(Vector)p.v.clone();
    }

    public void add(IDLObject obj) {
	String name="";
	try { name = obj.getName("name"); } catch(IDLflexException e) {}
	this.add(name, obj);
	/*
	try {
	    DefinitionKind defkind = (DefinitionKind)obj.getValue("defkind");
	    this.add( name, defkind );
	} catch(IDLflexException ex) {
	    System.err.println("WARNING: URP::add: getting defkind has thrown"+
			       " an exception!");
	    this.add( name, null );
	}
	*/
    }
    public void add(String name, IDLObject obj) {
	Object o[] = new Object[2];
	o[0] = name; o[1] = obj;
	v.addElement( o );
    }
    public void add0(String name, IDLObject obj) {
	Object o[] = new Object[2];
	o[0] = name; o[1] = obj;
	v.insertElementAt( o, 0 );
    }
    public int length() {
	return v.size();
    }
    public String name(int index) {
	return (String)((Object[])v.elementAt(index))[0];
    }
    public IDLObject obj(int index) {
	return (IDLObject)((Object[])v.elementAt(index))[1];
    }
    public DefinitionKind defkind(int index) {
	return (DefinitionKind)((Object[])v.elementAt(index))[1];
    }
    public String toString() {
	String val="";
	for(int i=0; i<v.size(); i++) val+=":"+name(i);
	return val;
    }
}
