/*
 * Modified by Gerhard Mller 2000
 */

/* Java Mapping specification for IDLFlex
 * $Id: APXJavaUtility.java,v 1.6 2001/11/30 11:14:27 aanenni Exp $
 *
 * Copyright (C) 2000  Hans Reiser
 * May be copied or modified under the terms of the GNU General Public License
 */

package org.aspectix.IDLflex.mapping;

import java.util.Vector;
import java.util.StringTokenizer;
import org.omg.CORBA.*;
import org.aspectix.IDLflex.UtilityResolvedPath;
import org.aspectix.IDLflex.IDLflexException;
import org.aspectix.IDLflex.NameCollisionResolver;
import org.aspectix.IDLflex.IDLDefCompiler;
import org.aspectix.IDLflex.IRObj.*;
import org.aspectix.IDLflex.Utility;

/** This class provides Java-specific extensions to the base Utility
 * class.  
 */
public class APXJavaUtility extends JavaUtility
{

    /* getJavaFullName:
     * additional types added to standard JavaUtility:
     * frag, fragimpl
     *
     * modified tpes:
     * ?
     */

    protected String getJavaFullName(IDLObject obj, String type) 
	throws IDLflexException
    {
	if(type.equals("")) 
	    return constructName(obj, "");
	
	// alias for skeleton
	if(type.equals("poa"))
	    return constructName(obj, "POA");
	
	// alias for tie
	if(type.equals("poatie"))
	    return constructName(obj, "POATie");
	
	// for AspectIX
	if(type.equals("fragope"))
	    return constructName(obj, "FragOpe");

	// for AspectIX Fragment Interface
	if(type.equals("fragifc"))
	    return constructName(obj, "FragmentIfc", "_");
	
	// for AspectIX Fragment
	if(type.equals("frag"))
	    return constructName(obj, "Fragment", "_");
	
	// for AspectIX Fragment
	if(type.equals("fragimpl"))
	    return constructName(obj, "FragmentImpl");
	
	
	return super.getJavaFullName(obj, type);
    }
    

//----------------------------------------------------------------------
/** This method is the overloaded method for &lt;GET &gt; text
  *  substitution.
  *
  *  supported arguments for 'whatstr':
  * (TODO: This comment needs to be updated!)
  *<ul><li><em>PACKAGEDEF</em>:
  *       Creates a 'package XXX;' statement, if the class which currently
  *       is created resides within a package.
  *    <li><em>PACKAGENAME</em>:
  *       Returns the name of the surrounding package of the specified
  *       object, i.e. all but the last part of its fully scoped name.
  *    <li><em>FILE:subspec</em>:
  *       Returns the filename corresponding to the class name returned
  *       by TYPE:subspec.
  *    <li><em>TYPE:subspec</em>:
  *       Creates a Java type declaration for the referenced IDL object
  *       If the object is located outside the package of the file 
  *       currently created, a fully scoped name is used. Name collision
  *       is done for all componentes of the fully scoped (or simple) 
  *       name.
  *    <li><em>CONSTVAL</em>:
  *       Value of a constant, formatted for Java syntax
  *    <li><em>DISCR:xxx</em>:
  *       xxx: num for numeric, sym for symbolic represenation of
  *       discriminator label (UnionMemberObj) or default discr (UnionObj)
  *    <li><em>DISCR_ADD_UNDERSCORE</em>:
  *       If exists a label called "discriminator" within an union, return
  *       an underscore '_'. Used for name collision resolving between
  *       union labels and the auto-generated 'discriminator' function.
  *</ul>
  *<p> valid values for 'subspec' are:
  *<ul><li><em>decl</em> basic data type class name
  *    <li><em>helper</em> helper class name
  *    <li><em>holder</em> holder class name
  *    <li><em>skeleton</em> skeleton class name
  *   <li><em>tie</em> tie class name
  *    <li><em>signatureif</em> signature interface class name
  *    <li><em>stub</em> stub class name
  *    <li><em>newarray</em> declaration of array of objects of the
  *            given class, to be used in a new clause. I.e.
  *            create "basicclassname[lenX][][]..[]". X is a
  *      value obtained from the "Special"-Object named 
  *      INDEX, the number of [] pairs is obtained by the
  *      dimensionality of the array/sequence.
  *    <li><em>basicidl</em> IDL name of a basic IDL definition
  *</ul>
  */
  public String getName(String whatstr, IDLObject obj) 
    throws IDLflexException
  {
      // get Token name
      String what;
      String sub;
      int pos;
      
      if(!whatstr.startsWith("JAVA:")) {
	  return super.getName(whatstr, obj);
      }
      String mywhatstr=whatstr.substring(5);
      
      if( (pos=mywhatstr.indexOf(":")) >=0 ) {
	  what=mywhatstr.substring(0,pos);
	  sub=mywhatstr.substring(pos+1);
      } else {
	  what=mywhatstr;
	  sub="";
      }

      
      // generate mapping specific file names
      // not really necessary in this place as its in JavaUtility as well
      // -- unless we change JAVA: to APX: in this class
      if(what.equals("FILE")) {
	  return getJavaPath(obj, sub);
      }
      
      //
      // extension for AspectIX
      //
      if(what.equals("INITFRAG")) {
	  if(!obj.is_a("InterfaceObj"))
	      throw new IDLflexException("<GET T=\"JAVA:INITFRAG\"> no "+
					 "InterfaceObject "+obj);
	  
	  IDLObject[] objlist = obj.getContentList("ALLBASE");
	  
	  if(objlist==null)
	      throw new IDLflexException("<GET T=\"INITFRAG\"> no ALLBASE "+obj);
	  
	  for(int i=0;i<objlist.length;i++)
	      if(objlist[i].getName("name").equals("APXObject")) {
		  if(i>0)      // root base found
		      return(objlist[i-1].getName("name"));
		  else         // object itself is the base for all types
		      return(obj.getName("name"));
	      }
	  
	  throw new IDLflexException("<GET T=\"INITFRAG\"> no base found "+obj);
      }
      
    return super.getName( whatstr, obj );
  }

    /** getAttribute implementation for Java mapping
     *  one special function is included here:
     *  the helper function mapping for a IDL interface requires tho
     *  create a narrow(java.lang.Object obj) method iff the interface
     *  is abstract or if it derived from any abstract class. The
     *  attribute "abstractbase" verifies this condition.
     */
    public boolean getAttribute(String attr, IDLObject obj) 
	throws IDLflexException
    {
	int pos;
	String spec;
	String sub;
	
	if(!attr.startsWith("JAVA:")) {
	    return super.getAttribute(attr, obj);
	}
	String myattr = attr.substring(5);

	if((pos=myattr.indexOf(":"))>0)  {
	    spec=myattr.substring(0,pos);
	    sub=myattr.substring(pos+1);
	} else {
	    spec=myattr;
	    sub="";
	}
	
	// checks if the name in TYPE:name is equal to the objects name
	if(spec.equals("TYPE")) {
	    String objname = obj.getName("name");
	    if(sub.equals(objname))
		return(true);
	    return(false);
	}

	//
	// extension for AspectIX
	//
	if(spec.equals("APXObject")) {
	    if(!obj.is_a("InterfaceObj"))
		throw new IDLflexException("<IF ATTR=\"APXObject\"> no InterfaceObject "+obj);

	    IDLObject[] objlist = obj.getContentList("ALLBASE");

	    if(objlist==null)
		throw new IDLflexException("<IF ATTR=\"APXObject\"> no ALLBASE "+obj);

	    if(obj.getName("name").equals("APXObject"))
		return(true);

	    for(int i=0;i<objlist.length;i++) {
		if(objlist[i].getName("name").equals("APXObject"))
		    return true;
	    }
	    return false;
	}

	return super.getAttribute(attr, obj);
    }
}

