/*
 * IDLflex -- A flexible, generic code generator for CORBA IDL
 *
 * Copyright (C) 2000  Hans Reiser, AspectIX Research Team
 *                     University of Erlangen-Nuernberg, Germany
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License.
 * The full text of the license can be found in the LICENSE.txt file.
 *
 * $Id$
 */

package org.aspectix.IDLflex.mapping;

import java.util.Vector;
import java.util.StringTokenizer;
import org.omg.CORBA.*;
import org.aspectix.IDLflex.UtilityResolvedPath;
import org.aspectix.IDLflex.IDLflexException;
import org.aspectix.IDLflex.NameCollisionResolver;
import org.aspectix.IDLflex.IDLDefCompiler;
import org.aspectix.IDLflex.IRObj.*;
import org.aspectix.IDLflex.Utility;

/** This class provides FAX-specific extensions to the base Utility
 * class.  
 */
public class FAXUtility extends org.aspectix.IDLflex.Utility {
    /** Initialization.
     *
     * After initializing the super class, this function creates instances
     * of the generic collision resolver paramterized for the Java
     * language mapping.
     */
    public void init(IDLDefCompiler compiler) {
	super.init(compiler);
    }
    
    //----------------------------------------------------------------------
    /** This method is the overloaded method for &lt;GET &gt; text
     *  substitution.
     *
     *  supported arguments for 'whatstr':
     *<ul><li><em>type</em>:
     *</ul>
     */
    public String getName(String whatstr, IDLObject obj) 
	throws IDLflexException
    {
	// get Token name
	String what;
	String sub;
	int pos;

	if(!whatstr.startsWith("FAX:")) {
	    return super.getName(whatstr, obj);
	}
	whatstr=whatstr.substring(4);

	if( (pos=whatstr.indexOf(":")) >=0 ) {
	    what=whatstr.substring(0,pos);
	    sub=whatstr.substring(pos+1);
	} else { what=whatstr; sub=""; }


	if(what.equals("type")) {
	    return get_basic_mapping(obj);
	}
	else if(what.equals("FILE")) {
	    String str;
	    try {
	    	str = obj.getName("name");
	    }catch(Exception ex) {
		str = "test";
	    }
	    if(sub.equals("header")) return str+".h";
	    else return str+sub;
	}
	return super.getName( whatstr, obj );
    }

    /** getAttribute implementation for FAX mapping
     */
    public boolean getAttribute(String attr, IDLObject obj) 
    throws IDLflexException {
	if(attr.equals("true-test")) {
	    return true;
	}
	return super.getAttribute(attr, obj);
    }
}
	
