package org.aspectix.IDLparser.grammar;

import antlr.ASTFactory;
import antlr.collections.AST;
import org.aspectix.IDLparser.tree.*;

public class IDLNodeFactory extends ASTFactory {

    public AST create(int type) {
        String classname;
        if((classname = IDLClassStrings.classes[type]) != null) {
            //System.err.println("FACTORY creating "+classname);
            try {
                AST newNode =  (AST) Class.forName("org.aspectix.IDLparser.tree."+classname).newInstance();
                newNode.initialize(type, "");
                return newNode;
            } catch(Exception e) {
                System.err.print("IDLFactory failed to create class ");
                System.err.println(e.getMessage() + " - " + e.toString());
                System.exit(0);
            }
        }
        //System.err.println("FACTORY creating default node "+type);   
        else {
            AST newNode = (AST) new IDLEntityNode();
            newNode.initialize(type, "");
            return newNode;
        }
        return super.create(type);
    }

    public AST create(int type, String txt) {  
        String classname;
        if((classname = IDLClassStrings.classes[type]) != null) {
            //System.err.println("FACTORY creating "+classname);
            try {
                AST newNode =  (AST) Class.forName("org.aspectix.IDLparser.tree."+classname).newInstance();
                newNode.initialize(type, txt);
                return newNode;
            } catch(Exception e) {
                System.err.print("IDLFactory failed to create class ");
                System.err.println(e.getMessage() + " - " + e.toString());
                System.exit(0);
            }
        }
        //System.err.println("FACTORY creating default node");       
        else {
            AST newNode = (AST) new IDLEntityNode();
            newNode.initialize(type, txt);
             return newNode;
        }
        return super.create(type);
    }

    public AST dup(AST ast) {
        if(ast == null) return null;
        //IDLEntityNode node = (IDLEntityNode) create(ast.getType(), ast.getText());
        //node.copyData((IDLEntityNode)ast);
        //return (AST) node;
        try {
            return (AST) ((IDLEntityNode)ast).clone();
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public AST dupTree(AST ast) {
        if(ast == null) return null;
        AST result = dup(ast);
        if(ast != null) {
            result.setFirstChild(dupList(ast.getFirstChild()));
        }
        return result;
    }     

    public AST dupList(AST t) {
	AST result = dupTree(t);            // if t == null, then result==null
	AST nt = result;
	while (t != null) {						// for each sibling of the root
	    t = t.getNextSibling();
	    nt.setNextSibling(dupTree(t));	// dup each subtree, building new tree
	    nt = nt.getNextSibling();
	}
	return result;
    }
    
}  

