// $ANTLR 2.7.1: "idl.g" -> "IDLParser.java"$

	package org.aspectix.IDLparser.grammar;

	import org.aspectix.IDLparser.tree.*;
	import org.aspectix.IDLparser.pub.*;
	import org.aspectix.IDLparser.util.*;

import antlr.TokenBuffer;
import antlr.TokenStreamException;
import antlr.TokenStreamIOException;
import antlr.ANTLRException;
import antlr.LLkParser;
import antlr.Token;
import antlr.TokenStream;
import antlr.RecognitionException;
import antlr.NoViableAltException;
import antlr.MismatchedTokenException;
import antlr.SemanticException;
import antlr.ParserSharedInputState;
import antlr.collections.impl.BitSet;
import antlr.collections.AST;
import antlr.ASTPair;
import antlr.collections.impl.ASTArray;

/**
 *  This is a complete parser for the IDL language as defined
 *  by the CORBA 2.0 specification.  It will allow those who
 *  need an IDL parser to get up-and-running very quickly.
 *  Though IDL's syntax is very similar to C++, it is also
 *  much simpler, due in large part to the fact that it is
 *  a declarative-only language.
 *  
 *  Some things that are not included are: Symbol table construction
 *  (it is not necessary for parsing, btw) and preprocessing (for
 *  IDL compiler #pragma directives). You can use just about any
 *  C or C++ preprocessor, but there is an interesting semantic
 *  issue if you are going to generate code: In C, #include is
 *  a literal include, in IDL, #include is more like Java's import:
 *  It adds definitions to the scope of the parse, but included
 *  definitions are not generated.
 *
 *  Jim Coker, jcoker@magelang.com
 */
public class IDLParser extends antlr.LLkParser
       implements IDLTokenTypes
 {

protected IDLParser(TokenBuffer tokenBuf, int k) {
  super(tokenBuf,k);
  tokenNames = _tokenNames;
}

public IDLParser(TokenBuffer tokenBuf) {
  this(tokenBuf,1);
}

protected IDLParser(TokenStream lexer, int k) {
  super(lexer,k);
  tokenNames = _tokenNames;
}

public IDLParser(TokenStream lexer) {
  this(lexer,1);
}

public IDLParser(ParserSharedInputState state) {
  super(state,1);
  tokenNames = _tokenNames;
}

	public final void specification() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST specification_AST = null;
		
		{
		int _cnt3=0;
		_loop3:
		do {
			if ((_tokenSet_0.member(LA(1)))) {
				definition();
				if (inputState.guessing==0) {
					astFactory.addASTChild(currentAST, returnAST);
				}
			}
			else {
				if ( _cnt3>=1 ) { break _loop3; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt3++;
		} while (true);
		}
		if ( inputState.guessing==0 ) {
			specification_AST = (AST)currentAST.root;
			
			specification_AST = (AST)astFactory.make( (new ASTArray(2)).add((AST)astFactory.create(SPEC)).add(specification_AST));
					
			currentAST.root = specification_AST;
			currentAST.child = specification_AST!=null &&specification_AST.getFirstChild()!=null ?
				specification_AST.getFirstChild() : specification_AST;
			currentAST.advanceChildToEnd();
		}
		specification_AST = (AST)currentAST.root;
		returnAST = specification_AST;
	}
	
	public final void definition() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST definition_AST = null;
		
		{
		switch ( LA(1)) {
		case PREPROC_DIRECTIVE:
		{
			preprocline();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			break;
		}
		case STRUCTURE:
		case UNION:
		case ENUM:
		case TYPEDEF:
		case NATIVE:
		{
			type_dcl();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			AST tmp1_AST = null;
			tmp1_AST = (AST)astFactory.create(LT(1));
			match(SEMI);
			break;
		}
		case CONSTANT:
		{
			const_dcl();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			AST tmp2_AST = null;
			tmp2_AST = (AST)astFactory.create(LT(1));
			match(SEMI);
			break;
		}
		case EXCEPT:
		{
			except_dcl();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			AST tmp3_AST = null;
			tmp3_AST = (AST)astFactory.create(LT(1));
			match(SEMI);
			break;
		}
		case MODULE:
		{
			module();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			AST tmp4_AST = null;
			tmp4_AST = (AST)astFactory.create(LT(1));
			match(SEMI);
			break;
		}
		default:
			boolean synPredMatched8 = false;
			if (((LA(1)==INTERF||LA(1)==LITERAL_local||LA(1)==LITERAL_abstract))) {
				int _m8 = mark();
				synPredMatched8 = true;
				inputState.guessing++;
				try {
					{
					{
					switch ( LA(1)) {
					case LITERAL_local:
					{
						match(LITERAL_local);
						break;
					}
					case LITERAL_abstract:
					{
						match(LITERAL_abstract);
						break;
					}
					case INTERF:
					{
						break;
					}
					default:
					{
						throw new NoViableAltException(LT(1), getFilename());
					}
					}
					}
					match(INTERF);
					}
				}
				catch (RecognitionException pe) {
					synPredMatched8 = false;
				}
				rewind(_m8);
				inputState.guessing--;
			}
			if ( synPredMatched8 ) {
				interf();
				if (inputState.guessing==0) {
					astFactory.addASTChild(currentAST, returnAST);
				}
				AST tmp5_AST = null;
				tmp5_AST = (AST)astFactory.create(LT(1));
				match(SEMI);
			}
			else {
				boolean synPredMatched11 = false;
				if (((LA(1)==VALUETYPE||LA(1)==LITERAL_abstract||LA(1)==LITERAL_custom))) {
					int _m11 = mark();
					synPredMatched11 = true;
					inputState.guessing++;
					try {
						{
						{
						switch ( LA(1)) {
						case LITERAL_custom:
						{
							match(LITERAL_custom);
							break;
						}
						case LITERAL_abstract:
						{
							match(LITERAL_abstract);
							break;
						}
						case VALUETYPE:
						{
							break;
						}
						default:
						{
							throw new NoViableAltException(LT(1), getFilename());
						}
						}
						}
						match(VALUETYPE);
						}
					}
					catch (RecognitionException pe) {
						synPredMatched11 = false;
					}
					rewind(_m11);
					inputState.guessing--;
				}
				if ( synPredMatched11 ) {
					value_type();
					if (inputState.guessing==0) {
						astFactory.addASTChild(currentAST, returnAST);
					}
					AST tmp6_AST = null;
					tmp6_AST = (AST)astFactory.create(LT(1));
					match(SEMI);
				}
			else {
				throw new NoViableAltException(LT(1), getFilename());
			}
			}}
			}
			definition_AST = (AST)currentAST.root;
			returnAST = definition_AST;
		}
		
	public final void preprocline() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST preprocline_AST = null;
		Token  p = null;
		AST p_AST = null;
		
		{
		p = LT(1);
		if (inputState.guessing==0) {
			p_AST = (AST)astFactory.create(p);
		}
		match(PREPROC_DIRECTIVE);
		if ( inputState.guessing==0 ) {
			preprocline_AST = (AST)currentAST.root;
			
					 preprocline_AST= (AST)astFactory.make( (new ASTArray(2)).add((AST)astFactory.create(PREPROC)).add(preprocline_AST));
					 ((IDLEntityNode)preprocline_AST).setLine(((IDLEntityNode)p_AST).getLine()); 
					 preprocline_AST.setText(p_AST.getText()); 
			
			currentAST.root = preprocline_AST;
			currentAST.child = preprocline_AST!=null &&preprocline_AST.getFirstChild()!=null ?
				preprocline_AST.getFirstChild() : preprocline_AST;
			currentAST.advanceChildToEnd();
		}
		}
		preprocline_AST = (AST)currentAST.root;
		returnAST = preprocline_AST;
	}
	
	public final void type_dcl() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST type_dcl_AST = null;
		AST a_AST = null;
		AST d_AST = null;
		AST e_AST = null;
		AST b_AST = null;
		AST c_AST = null;
		AST i_AST = null;
		
			TypedefNode newNode, current = null;
			TypedefNode begin = null;
			AST down;
		
		
		switch ( LA(1)) {
		case TYPEDEF:
		{
			TypedefNode tmp7_AST = null;
			if (inputState.guessing==0) {
				tmp7_AST = new TypedefNode(LT(1));
				astFactory.makeASTRoot(currentAST, tmp7_AST);
			}
			match(TYPEDEF);
			type_spec();
			if (inputState.guessing==0) {
				a_AST = (AST)returnAST;
			}
			identifier();
			if (inputState.guessing==0) {
				d_AST = (AST)returnAST;
			}
			array_decl();
			if (inputState.guessing==0) {
				e_AST = (AST)returnAST;
			}
			{
			_loop68:
			do {
				if ((LA(1)==COMMA)) {
					AST tmp8_AST = null;
					tmp8_AST = (AST)astFactory.create(LT(1));
					match(COMMA);
					identifier();
					if (inputState.guessing==0) {
						b_AST = (AST)returnAST;
					}
					array_decl();
					if (inputState.guessing==0) {
						c_AST = (AST)returnAST;
					}
					if ( inputState.guessing==0 ) {
						
										newNode = new TypedefNode();
										((IDLEntityNode)a_AST).setUsed();
										newNode.setLine(((IDLEntityNode)b_AST).getLine());
										newNode.setText(b_AST.getText());
										if(c_AST == null) newNode.addChild(astFactory.dupTree(a_AST)); 
										else {
											/* The following part adds the type_spec to the end of the 
											   array_decl i.e. adds the given type to the array. */
											((IDLEntityNode)c_AST).setUsed();
											newNode.addChild(c_AST);
											down = c_AST.getFirstChild();
											while(down.getNextSibling() != null) down = down.getNextSibling().getFirstChild();
											down.setNextSibling(astFactory.dupTree(a_AST));
										}
										if(begin == null) begin = newNode;
										else current.setNextSibling(newNode);
										current = newNode;
									
					}
				}
				else {
					break _loop68;
				}
				
			} while (true);
			}
			if ( inputState.guessing==0 ) {
				type_dcl_AST = (AST)currentAST.root;
				
							//#type_dcl = #([TYPEDEF], #type_dcl);
							((IDLEntityNode)type_dcl_AST).setLine(((IDLEntityNode)d_AST).getLine());
							type_dcl_AST.setText(d_AST.getText());
							((IDLEntityNode)a_AST).setUsed();
							if(e_AST == null) type_dcl_AST.addChild(a_AST);
							else  {
								/* The following part adds the type_spec to the end of the 
								   array_decl i.e. adds the given type to the array. */
								((IDLEntityNode)e_AST).setUsed();
								type_dcl_AST.addChild(e_AST);
								down = e_AST.getFirstChild();
								while(down.getNextSibling() != null) down = down.getNextSibling().getFirstChild();
								down.setNextSibling(a_AST);
							}  
				if(begin != null) type_dcl_AST.setNextSibling(begin); 
						
			}
			type_dcl_AST = (AST)currentAST.root;
			break;
		}
		case STRUCTURE:
		{
			struct_type();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			type_dcl_AST = (AST)currentAST.root;
			break;
		}
		case UNION:
		{
			union_type();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			type_dcl_AST = (AST)currentAST.root;
			break;
		}
		case ENUM:
		{
			enum_type();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			type_dcl_AST = (AST)currentAST.root;
			break;
		}
		case NATIVE:
		{
			NativeNode tmp9_AST = null;
			if (inputState.guessing==0) {
				tmp9_AST = new NativeNode(LT(1));
				astFactory.makeASTRoot(currentAST, tmp9_AST);
			}
			match(NATIVE);
			identifier();
			if (inputState.guessing==0) {
				i_AST = (AST)returnAST;
			}
			if ( inputState.guessing==0 ) {
				type_dcl_AST = (AST)currentAST.root;
				
							type_dcl_AST.setText(i_AST.getText());
						
			}
			type_dcl_AST = (AST)currentAST.root;
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		returnAST = type_dcl_AST;
	}
	
	public final void const_dcl() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST const_dcl_AST = null;
		AST b_AST = null;
		AST a_AST = null;
		
		ConstDefNode tmp10_AST = null;
		if (inputState.guessing==0) {
			tmp10_AST = new ConstDefNode(LT(1));
			astFactory.makeASTRoot(currentAST, tmp10_AST);
		}
		match(CONSTANT);
		const_type();
		if (inputState.guessing==0) {
			b_AST = (AST)returnAST;
			astFactory.addASTChild(currentAST, returnAST);
		}
		identifier();
		if (inputState.guessing==0) {
			a_AST = (AST)returnAST;
		}
		AST tmp11_AST = null;
		tmp11_AST = (AST)astFactory.create(LT(1));
		match(ASSIGN);
		const_exp();
		if (inputState.guessing==0) {
			astFactory.addASTChild(currentAST, returnAST);
		}
		if ( inputState.guessing==0 ) {
			
			tmp10_AST.setText(a_AST.getText());
						((IDLEntityNode)b_AST).setUsed();
			
		}
		const_dcl_AST = (AST)currentAST.root;
		returnAST = const_dcl_AST;
	}
	
	public final void except_dcl() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST except_dcl_AST = null;
		AST name_AST = null;
		
		ExceptNode tmp12_AST = null;
		if (inputState.guessing==0) {
			tmp12_AST = new ExceptNode(LT(1));
			astFactory.makeASTRoot(currentAST, tmp12_AST);
		}
		match(EXCEPT);
		identifier();
		if (inputState.guessing==0) {
			name_AST = (AST)returnAST;
		}
		AST tmp13_AST = null;
		tmp13_AST = (AST)astFactory.create(LT(1));
		match(LCURLY);
		{
		_loop105:
		do {
			if ((_tokenSet_1.member(LA(1)))) {
				member();
				if (inputState.guessing==0) {
					astFactory.addASTChild(currentAST, returnAST);
				}
			}
			else {
				break _loop105;
			}
			
		} while (true);
		}
		AST tmp14_AST = null;
		tmp14_AST = (AST)astFactory.create(LT(1));
		match(RCURLY);
		if ( inputState.guessing==0 ) {
			
						tmp12_AST.setText(name_AST.getText());
					
		}
		except_dcl_AST = (AST)currentAST.root;
		returnAST = except_dcl_AST;
	}
	
	public final void interf() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST interf_AST = null;
		Token  l = null;
		AST l_AST = null;
		Token  a = null;
		AST a_AST = null;
		AST name_AST = null;
		AST i_AST = null;
		Token  b = null;
		AST b_AST = null;
		
		{
		switch ( LA(1)) {
		case LITERAL_local:
		{
			l = LT(1);
			if (inputState.guessing==0) {
				l_AST = (AST)astFactory.create(l);
			}
			match(LITERAL_local);
			break;
		}
		case LITERAL_abstract:
		{
			a = LT(1);
			if (inputState.guessing==0) {
				a_AST = (AST)astFactory.create(a);
			}
			match(LITERAL_abstract);
			break;
		}
		case INTERF:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		InterfNode tmp15_AST = null;
		if (inputState.guessing==0) {
			tmp15_AST = new InterfNode(LT(1));
			astFactory.makeASTRoot(currentAST, tmp15_AST);
		}
		match(INTERF);
		identifier();
		if (inputState.guessing==0) {
			name_AST = (AST)returnAST;
		}
		{
		switch ( LA(1)) {
		case LCURLY:
		case COLON:
		{
			opt_inheritance_spec();
			if (inputState.guessing==0) {
				i_AST = (AST)returnAST;
				astFactory.addASTChild(currentAST, returnAST);
			}
			b = LT(1);
			if (inputState.guessing==0) {
				b_AST = (AST)astFactory.create(b);
			}
			match(LCURLY);
			{
			_loop21:
			do {
				if ((_tokenSet_2.member(LA(1)))) {
					export();
					if (inputState.guessing==0) {
						astFactory.addASTChild(currentAST, returnAST);
					}
				}
				else {
					break _loop21;
				}
				
			} while (true);
			}
			AST tmp16_AST = null;
			tmp16_AST = (AST)astFactory.create(LT(1));
			match(RCURLY);
			break;
		}
		case SEMI:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		if ( inputState.guessing==0 ) {
			
				    tmp15_AST.setText(name_AST.getText());
				    if(i_AST != null) {
							tmp15_AST.setInherit();
					    }
				            if(a_AST != null) {
							tmp15_AST.setAbstractIf();
					    }
					    if(l_AST != null) {
							tmp15_AST.setLocalIf();
					    }
				            if(b_AST == null) {
							tmp15_AST.setForwardDecl();
					    }
					
		}
		interf_AST = (AST)currentAST.root;
		returnAST = interf_AST;
	}
	
	public final void module() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST module_AST = null;
		AST name_AST = null;
		
		ModuleNode tmp17_AST = null;
		if (inputState.guessing==0) {
			tmp17_AST = new ModuleNode(LT(1));
			astFactory.makeASTRoot(currentAST, tmp17_AST);
		}
		match(MODULE);
		identifier();
		if (inputState.guessing==0) {
			name_AST = (AST)returnAST;
		}
		AST tmp18_AST = null;
		tmp18_AST = (AST)astFactory.create(LT(1));
		match(LCURLY);
		{
		int _cnt16=0;
		_loop16:
		do {
			if ((_tokenSet_0.member(LA(1)))) {
				definition();
				if (inputState.guessing==0) {
					astFactory.addASTChild(currentAST, returnAST);
				}
			}
			else {
				if ( _cnt16>=1 ) { break _loop16; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt16++;
		} while (true);
		}
		AST tmp19_AST = null;
		tmp19_AST = (AST)astFactory.create(LT(1));
		match(RCURLY);
		if ( inputState.guessing==0 ) {
			
						tmp17_AST.setText(name_AST.getText());
			
		}
		module_AST = (AST)currentAST.root;
		returnAST = module_AST;
	}
	
	public final void value_type() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST value_type_AST = null;
		Token  c = null;
		AST c_AST = null;
		Token  a = null;
		AST a_AST = null;
		AST name_AST = null;
		Token  inherit = null;
		AST inherit_AST = null;
		Token  supp = null;
		SupportNode supp_AST = null;
		Token  body = null;
		AST body_AST = null;
		AST box_AST = null;
		
		{
		switch ( LA(1)) {
		case LITERAL_custom:
		{
			c = LT(1);
			if (inputState.guessing==0) {
				c_AST = (AST)astFactory.create(c);
			}
			match(LITERAL_custom);
			break;
		}
		case LITERAL_abstract:
		{
			a = LT(1);
			if (inputState.guessing==0) {
				a_AST = (AST)astFactory.create(a);
			}
			match(LITERAL_abstract);
			break;
		}
		case VALUETYPE:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		ValueTypeNode tmp20_AST = null;
		if (inputState.guessing==0) {
			tmp20_AST = new ValueTypeNode(LT(1));
			astFactory.makeASTRoot(currentAST, tmp20_AST);
		}
		match(VALUETYPE);
		identifier();
		if (inputState.guessing==0) {
			name_AST = (AST)returnAST;
		}
		{
		switch ( LA(1)) {
		case SUPPORT:
		case LCURLY:
		case COLON:
		{
			{
			{
			switch ( LA(1)) {
			case COLON:
			{
				inherit = LT(1);
				if (inputState.guessing==0) {
					inherit_AST = (AST)astFactory.create(inherit);
				}
				match(COLON);
				scoped_name_list();
				if (inputState.guessing==0) {
					astFactory.addASTChild(currentAST, returnAST);
				}
				break;
			}
			case SUPPORT:
			case LCURLY:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			{
			switch ( LA(1)) {
			case SUPPORT:
			{
				supp = LT(1);
				if (inputState.guessing==0) {
					supp_AST = new SupportNode(supp);
				}
				match(SUPPORT);
				scoped_name_list();
				if (inputState.guessing==0) {
					astFactory.addASTChild(currentAST, returnAST);
				}
				break;
			}
			case LCURLY:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			body = LT(1);
			if (inputState.guessing==0) {
				body_AST = (AST)astFactory.create(body);
			}
			match(LCURLY);
			{
			_loop144:
			do {
				if ((_tokenSet_3.member(LA(1)))) {
					value_element();
					if (inputState.guessing==0) {
						astFactory.addASTChild(currentAST, returnAST);
					}
				}
				else {
					break _loop144;
				}
				
			} while (true);
			}
			AST tmp21_AST = null;
			tmp21_AST = (AST)astFactory.create(LT(1));
			match(RCURLY);
			}
			break;
		}
		case STRUCTURE:
		case UNION:
		case ENUM:
		case STRING:
		case FIXED:
		case WSTRING:
		case SEQUENCE:
		case SCOPEOP:
		case IDENT:
		case LITERAL_float:
		case LITERAL_double:
		case LITERAL_long:
		case LITERAL_short:
		case LITERAL_unsigned:
		case LITERAL_char:
		case LITERAL_wchar:
		case LITERAL_any:
		case LITERAL_Object:
		case LITERAL_ValueBase:
		case LITERAL_octet:
		case LITERAL_boolean:
		{
			type_spec();
			if (inputState.guessing==0) {
				box_AST = (AST)returnAST;
			}
			break;
		}
		case SEMI:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		if ( inputState.guessing==0 ) {
			
					   tmp20_AST.setText(name_AST.getText());
					   if(inherit_AST != null) {
						 tmp20_AST.setInherits();
					   }
					   if(supp_AST != null) {
					 	 tmp20_AST.setSupports();
					   }
					   if(c_AST != null) {
						 tmp20_AST.setCustom();
					   }
					   if(a_AST != null) {
						 tmp20_AST.setAbstractValue();
					   }
					   if(box_AST != null) {
						 tmp20_AST.setBoxed();
					   } else if (body_AST != null) {
					   } else {
					         tmp20_AST.setForwardDecl();
					   }
				
		}
		value_type_AST = (AST)currentAST.root;
		returnAST = value_type_AST;
	}
	
	public final void identifier() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST identifier_AST = null;
		Token  a = null;
		AST a_AST = null;
		
		a = LT(1);
		if (inputState.guessing==0) {
			a_AST = (AST)astFactory.create(a);
		}
		match(IDENT);
		if ( inputState.guessing==0 ) {
			identifier_AST = (AST)currentAST.root;
			
						identifier_AST = (AST)astFactory.make( (new ASTArray(2)).add((AST)astFactory.create(SCOPED_NAME)).add(identifier_AST));
						((IDLEntityNode)identifier_AST).setUsed();
			// dl9rdz additions start here (escaped identifiers)
						String temp = a_AST.getText();
						if(temp.startsWith("_")) temp=temp.substring(1);
						identifier_AST.setText(temp);
			// dl9rdz additions end here
			((IDLEntityNode)identifier_AST).setLine(((IDLEntityNode)a_AST).getLine());
					
			currentAST.root = identifier_AST;
			currentAST.child = identifier_AST!=null &&identifier_AST.getFirstChild()!=null ?
				identifier_AST.getFirstChild() : identifier_AST;
			currentAST.advanceChildToEnd();
		}
		identifier_AST = (AST)currentAST.root;
		returnAST = identifier_AST;
	}
	
	public final void opt_inheritance_spec() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST opt_inheritance_spec_AST = null;
		Token  a = null;
		AST a_AST = null;
		
		switch ( LA(1)) {
		case COLON:
		{
			a = LT(1);
			if (inputState.guessing==0) {
				a_AST = (AST)astFactory.create(a);
			}
			match(COLON);
			scoped_name_list();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			if ( inputState.guessing==0 ) {
				opt_inheritance_spec_AST = (AST)currentAST.root;
				
				opt_inheritance_spec_AST = (AST)astFactory.make( (new ASTArray(2)).add((AST)astFactory.create(INHERIT)).add(opt_inheritance_spec_AST));
				((IDLEntityNode)opt_inheritance_spec_AST).setLine(((IDLEntityNode)a_AST).getLine());
				
				currentAST.root = opt_inheritance_spec_AST;
				currentAST.child = opt_inheritance_spec_AST!=null &&opt_inheritance_spec_AST.getFirstChild()!=null ?
					opt_inheritance_spec_AST.getFirstChild() : opt_inheritance_spec_AST;
				currentAST.advanceChildToEnd();
			}
			opt_inheritance_spec_AST = (AST)currentAST.root;
			break;
		}
		case LCURLY:
		{
			opt_inheritance_spec_AST = (AST)currentAST.root;
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		returnAST = opt_inheritance_spec_AST;
	}
	
	public final void export() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST export_AST = null;
		
		{
		switch ( LA(1)) {
		case STRUCTURE:
		case UNION:
		case ENUM:
		case TYPEDEF:
		case NATIVE:
		{
			type_dcl();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			AST tmp22_AST = null;
			tmp22_AST = (AST)astFactory.create(LT(1));
			match(SEMI);
			break;
		}
		case CONSTANT:
		{
			const_dcl();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			AST tmp23_AST = null;
			tmp23_AST = (AST)astFactory.create(LT(1));
			match(SEMI);
			break;
		}
		case EXCEPT:
		{
			except_dcl();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			AST tmp24_AST = null;
			tmp24_AST = (AST)astFactory.create(LT(1));
			match(SEMI);
			break;
		}
		case ATTRIBUTE:
		case LITERAL_readonly:
		{
			attr_dcl();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			AST tmp25_AST = null;
			tmp25_AST = (AST)astFactory.create(LT(1));
			match(SEMI);
			break;
		}
		case STRING:
		case FIXED:
		case WSTRING:
		case SCOPEOP:
		case IDENT:
		case LITERAL_oneway:
		case LITERAL_void:
		case LITERAL_float:
		case LITERAL_double:
		case LITERAL_long:
		case LITERAL_short:
		case LITERAL_unsigned:
		case LITERAL_char:
		case LITERAL_wchar:
		case LITERAL_any:
		case LITERAL_Object:
		case LITERAL_ValueBase:
		case LITERAL_octet:
		case LITERAL_boolean:
		{
			op_dcl();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			AST tmp26_AST = null;
			tmp26_AST = (AST)astFactory.create(LT(1));
			match(SEMI);
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		export_AST = (AST)currentAST.root;
		returnAST = export_AST;
	}
	
	public final void attr_dcl() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST attr_dcl_AST = null;
		Token  a = null;
		AST a_AST = null;
		AST c_AST = null;
		AST d_AST = null;
		AST b_AST = null;
		
			AttrNode newNode, current = null; 
			AttrNode begin = null;
		
		
		{
		switch ( LA(1)) {
		case LITERAL_readonly:
		{
			a = LT(1);
			if (inputState.guessing==0) {
				a_AST = (AST)astFactory.create(a);
			}
			match(LITERAL_readonly);
			break;
		}
		case ATTRIBUTE:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		AttrNode tmp27_AST = null;
		if (inputState.guessing==0) {
			tmp27_AST = new AttrNode(LT(1));
			astFactory.makeASTRoot(currentAST, tmp27_AST);
		}
		match(ATTRIBUTE);
		param_type_spec();
		if (inputState.guessing==0) {
			c_AST = (AST)returnAST;
			astFactory.addASTChild(currentAST, returnAST);
		}
		identifier();
		if (inputState.guessing==0) {
			d_AST = (AST)returnAST;
		}
		{
		_loop102:
		do {
			if ((LA(1)==COMMA)) {
				AST tmp28_AST = null;
				tmp28_AST = (AST)astFactory.create(LT(1));
				match(COMMA);
				identifier();
				if (inputState.guessing==0) {
					b_AST = (AST)returnAST;
				}
				if ( inputState.guessing==0 ) {
					
									newNode = new AttrNode();
									newNode.setText(b_AST.getText());  	
									((IDLEntityNode)c_AST).setUsed(); 
									newNode.setFirstChild(astFactory.dupTree(c_AST));
									newNode.setLine(((IDLEntityNode)b_AST).getLine());
									if(a_AST != null) newNode.setReadonly();
					if(begin == null) begin = newNode;
					else current.setNextSibling(newNode); 
									current = newNode;
					
				}
			}
			else {
				break _loop102;
			}
			
		} while (true);
		}
		if ( inputState.guessing==0 ) {
			
			tmp27_AST.setText(d_AST.getText());
						((IDLEntityNode)c_AST).setUsed(); 
						if(a_AST != null) tmp27_AST.setReadonly();
			if(begin != null) tmp27_AST.setNextSibling(begin);
					
		}
		attr_dcl_AST = (AST)currentAST.root;
		returnAST = attr_dcl_AST;
	}
	
	public final void op_dcl() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST op_dcl_AST = null;
		Token  a = null;
		AST a_AST = null;
		AST b_AST = null;
		AST name_AST = null;
		
		{
		switch ( LA(1)) {
		case LITERAL_oneway:
		{
			a = LT(1);
			if (inputState.guessing==0) {
				a_AST = (AST)astFactory.create(a);
			}
			match(LITERAL_oneway);
			break;
		}
		case STRING:
		case FIXED:
		case WSTRING:
		case SCOPEOP:
		case IDENT:
		case LITERAL_void:
		case LITERAL_float:
		case LITERAL_double:
		case LITERAL_long:
		case LITERAL_short:
		case LITERAL_unsigned:
		case LITERAL_char:
		case LITERAL_wchar:
		case LITERAL_any:
		case LITERAL_Object:
		case LITERAL_ValueBase:
		case LITERAL_octet:
		case LITERAL_boolean:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		op_type_spec();
		if (inputState.guessing==0) {
			b_AST = (AST)returnAST;
			astFactory.addASTChild(currentAST, returnAST);
		}
		identifier();
		if (inputState.guessing==0) {
			name_AST = (AST)returnAST;
		}
		parameter_dcls();
		if (inputState.guessing==0) {
			astFactory.addASTChild(currentAST, returnAST);
		}
		{
		switch ( LA(1)) {
		case RAISES:
		{
			raises_expr();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			break;
		}
		case CONTEXT:
		case SEMI:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		switch ( LA(1)) {
		case CONTEXT:
		{
			context_expr();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			break;
		}
		case SEMI:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		if ( inputState.guessing==0 ) {
			op_dcl_AST = (AST)currentAST.root;
			
						op_dcl_AST = (AST)astFactory.make( (new ASTArray(2)).add((AST)astFactory.create(OP_DECL)).add(op_dcl_AST));
						((IDLEntityNode)b_AST).setUsed();
			op_dcl_AST.setText(name_AST.getText());
			if(a_AST != null) ((OpDeclNode)op_dcl_AST).setOneway();
			((IDLEntityNode)op_dcl_AST).setLine(((IDLEntityNode)name_AST).getLine());
			
			currentAST.root = op_dcl_AST;
			currentAST.child = op_dcl_AST!=null &&op_dcl_AST.getFirstChild()!=null ?
				op_dcl_AST.getFirstChild() : op_dcl_AST;
			currentAST.advanceChildToEnd();
		}
		op_dcl_AST = (AST)currentAST.root;
		returnAST = op_dcl_AST;
	}
	
	public final void scoped_name_list() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST scoped_name_list_AST = null;
		AST a_AST = null;
		AST b_AST = null;
		
		scoped_name();
		if (inputState.guessing==0) {
			a_AST = (AST)returnAST;
			astFactory.addASTChild(currentAST, returnAST);
		}
		{
		_loop27:
		do {
			if ((LA(1)==COMMA)) {
				AST tmp29_AST = null;
				tmp29_AST = (AST)astFactory.create(LT(1));
				match(COMMA);
				scoped_name();
				if (inputState.guessing==0) {
					b_AST = (AST)returnAST;
					astFactory.addASTChild(currentAST, returnAST);
				}
				if ( inputState.guessing==0 ) {
					
									((IDLEntityNode)b_AST).setUsed();
								
				}
			}
			else {
				break _loop27;
			}
			
		} while (true);
		}
		if ( inputState.guessing==0 ) {
			
						((IDLEntityNode)a_AST).setUsed();
					
		}
		scoped_name_list_AST = (AST)currentAST.root;
		returnAST = scoped_name_list_AST;
	}
	
	public final void scoped_name() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST scoped_name_AST = null;
		Token  a = null;
		AST a_AST = null;
		AST b_AST = null;
		AST c_AST = null;
		String text = "";
		
		{
		switch ( LA(1)) {
		case SCOPEOP:
		{
			a = LT(1);
			if (inputState.guessing==0) {
				a_AST = (AST)astFactory.create(a);
			}
			match(SCOPEOP);
			break;
		}
		case IDENT:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		identifier();
		if (inputState.guessing==0) {
			b_AST = (AST)returnAST;
		}
		{
		_loop31:
		do {
			if ((LA(1)==SCOPEOP)) {
				AST tmp30_AST = null;
				tmp30_AST = (AST)astFactory.create(LT(1));
				match(SCOPEOP);
				identifier();
				if (inputState.guessing==0) {
					c_AST = (AST)returnAST;
				}
				if ( inputState.guessing==0 ) {
					
									text  = text.concat("::"+c_AST.getText());
								
				}
			}
			else {
				break _loop31;
			}
			
		} while (true);
		}
		if ( inputState.guessing==0 ) {
			scoped_name_AST = (AST)currentAST.root;
			
						text = b_AST.getText()+text;
						if(a_AST != null) text = "::"+text;
						scoped_name_AST = (AST)astFactory.make( (new ASTArray(2)).add((AST)astFactory.create(SCOPED_NAME)).add(scoped_name_AST));
						scoped_name_AST.setText(text);
						((IDLEntityNode)scoped_name_AST).setLine(((IDLEntityNode)b_AST).getLine());
						if(a_AST != null) ((ScopedNameNode) scoped_name_AST).setScopeResolution();
			
			currentAST.root = scoped_name_AST;
			currentAST.child = scoped_name_AST!=null &&scoped_name_AST.getFirstChild()!=null ?
				scoped_name_AST.getFirstChild() : scoped_name_AST;
			currentAST.advanceChildToEnd();
		}
		scoped_name_AST = (AST)currentAST.root;
		returnAST = scoped_name_AST;
	}
	
	public final void const_type() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST const_type_AST = null;
		
		switch ( LA(1)) {
		case LITERAL_float:
		case LITERAL_double:
		case LITERAL_long:
		case LITERAL_short:
		case LITERAL_unsigned:
		{
			int_or_float();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			const_type_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_char:
		{
			char_type();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			const_type_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_boolean:
		{
			boolean_type();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			const_type_AST = (AST)currentAST.root;
			break;
		}
		case STRING:
		{
			string_type();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			const_type_AST = (AST)currentAST.root;
			break;
		}
		case SCOPEOP:
		case IDENT:
		{
			scoped_name();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			const_type_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_wchar:
		{
			wide_char_type();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			const_type_AST = (AST)currentAST.root;
			break;
		}
		case WSTRING:
		{
			wide_string_type();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			const_type_AST = (AST)currentAST.root;
			break;
		}
		case FIXED:
		{
			fixed_pt_const_type();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			const_type_AST = (AST)currentAST.root;
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		returnAST = const_type_AST;
	}
	
	public final void const_exp() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST const_exp_AST = null;
		
		or_expr();
		if (inputState.guessing==0) {
			astFactory.addASTChild(currentAST, returnAST);
		}
		const_exp_AST = (AST)currentAST.root;
		returnAST = const_exp_AST;
	}
	
	public final void int_or_float() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST int_or_float_AST = null;
		
		if ((((LA(1) >= LITERAL_long && LA(1) <= LITERAL_unsigned)))&&((LA(2) != LITERAL_double) && ((LA(1)==LITERAL_short) || (LA(1)==LITERAL_long) 
			|| (LA(1)==LITERAL_unsigned)))) {
			integer_type();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			int_or_float_AST = (AST)currentAST.root;
		}
		else if ((((LA(1) >= LITERAL_float && LA(1) <= LITERAL_long)))&&((LA(2) == LITERAL_double) || (LA(1)==LITERAL_double) || (LA(1)==LITERAL_float))) {
			floating_pt_type();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			int_or_float_AST = (AST)currentAST.root;
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		returnAST = int_or_float_AST;
	}
	
	public final void char_type() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST char_type_AST = null;
		Token  a = null;
		AST a_AST = null;
		
		a = LT(1);
		if (inputState.guessing==0) {
			a_AST = (AST)astFactory.create(a);
		}
		match(LITERAL_char);
		if ( inputState.guessing==0 ) {
			char_type_AST = (AST)currentAST.root;
			
						char_type_AST = (AST)astFactory.make( (new ASTArray(2)).add((AST)astFactory.create(BASETYPE)).add(char_type_AST));
						char_type_AST.setText("char");
						((IDLEntityNode)char_type_AST).setLine(((IDLEntityNode)a_AST).getLine()); 
					
			currentAST.root = char_type_AST;
			currentAST.child = char_type_AST!=null &&char_type_AST.getFirstChild()!=null ?
				char_type_AST.getFirstChild() : char_type_AST;
			currentAST.advanceChildToEnd();
		}
		char_type_AST = (AST)currentAST.root;
		returnAST = char_type_AST;
	}
	
	public final void boolean_type() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST boolean_type_AST = null;
		Token  a = null;
		AST a_AST = null;
		
		a = LT(1);
		if (inputState.guessing==0) {
			a_AST = (AST)astFactory.create(a);
		}
		match(LITERAL_boolean);
		if ( inputState.guessing==0 ) {
			boolean_type_AST = (AST)currentAST.root;
			
			boolean_type_AST = (AST)astFactory.make( (new ASTArray(2)).add((AST)astFactory.create(BASETYPE)).add(boolean_type_AST));
			boolean_type_AST.setText("boolean");
						((IDLEntityNode)boolean_type_AST).setLine(((IDLEntityNode)a_AST).getLine());
			
			currentAST.root = boolean_type_AST;
			currentAST.child = boolean_type_AST!=null &&boolean_type_AST.getFirstChild()!=null ?
				boolean_type_AST.getFirstChild() : boolean_type_AST;
			currentAST.advanceChildToEnd();
		}
		boolean_type_AST = (AST)currentAST.root;
		returnAST = boolean_type_AST;
	}
	
	public final void string_type() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST string_type_AST = null;
		
		StringNode tmp31_AST = null;
		if (inputState.guessing==0) {
			tmp31_AST = new StringNode(LT(1));
			astFactory.makeASTRoot(currentAST, tmp31_AST);
		}
		match(STRING);
		{
		switch ( LA(1)) {
		case LT:
		{
			AST tmp32_AST = null;
			tmp32_AST = (AST)astFactory.create(LT(1));
			match(LT);
			const_exp();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			AST tmp33_AST = null;
			tmp33_AST = (AST)astFactory.create(LT(1));
			match(GT);
			break;
		}
		case SEMI:
		case COMMA:
		case IDENT:
		case GT:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		string_type_AST = (AST)currentAST.root;
		returnAST = string_type_AST;
	}
	
	public final void wide_char_type() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST wide_char_type_AST = null;
		Token  a = null;
		AST a_AST = null;
		
		a = LT(1);
		if (inputState.guessing==0) {
			a_AST = (AST)astFactory.create(a);
		}
		match(LITERAL_wchar);
		if ( inputState.guessing==0 ) {
			wide_char_type_AST = (AST)currentAST.root;
			
						wide_char_type_AST = (AST)astFactory.make( (new ASTArray(2)).add((AST)astFactory.create(BASETYPE)).add(wide_char_type_AST));
						wide_char_type_AST.setText("wchar");
						((IDLEntityNode)wide_char_type_AST).setLine(((IDLEntityNode)a_AST).getLine()); 
					
			currentAST.root = wide_char_type_AST;
			currentAST.child = wide_char_type_AST!=null &&wide_char_type_AST.getFirstChild()!=null ?
				wide_char_type_AST.getFirstChild() : wide_char_type_AST;
			currentAST.advanceChildToEnd();
		}
		wide_char_type_AST = (AST)currentAST.root;
		returnAST = wide_char_type_AST;
	}
	
	public final void wide_string_type() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST wide_string_type_AST = null;
		
		StringNode tmp34_AST = null;
		if (inputState.guessing==0) {
			tmp34_AST = new StringNode(LT(1));
			astFactory.makeASTRoot(currentAST, tmp34_AST);
		}
		match(WSTRING);
		{
		switch ( LA(1)) {
		case LT:
		{
			AST tmp35_AST = null;
			tmp35_AST = (AST)astFactory.create(LT(1));
			match(LT);
			const_exp();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			AST tmp36_AST = null;
			tmp36_AST = (AST)astFactory.create(LT(1));
			match(GT);
			break;
		}
		case SEMI:
		case COMMA:
		case IDENT:
		case GT:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		wide_string_type_AST = (AST)currentAST.root;
		returnAST = wide_string_type_AST;
	}
	
	public final void fixed_pt_const_type() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST fixed_pt_const_type_AST = null;
		Token  a = null;
		AST a_AST = null;
		
		a = LT(1);
		if (inputState.guessing==0) {
			a_AST = (AST)astFactory.create(a);
		}
		match(FIXED);
		if ( inputState.guessing==0 ) {
			fixed_pt_const_type_AST = (AST)currentAST.root;
			
						fixed_pt_const_type_AST = (AST)astFactory.make( (new ASTArray(2)).add((AST)astFactory.create(BASETYPE)).add(fixed_pt_const_type_AST));
				        fixed_pt_const_type_AST.setText("fixed");
						((IDLEntityNode)fixed_pt_const_type_AST).setLine(((IDLEntityNode)a_AST).getLine());    
					
			currentAST.root = fixed_pt_const_type_AST;
			currentAST.child = fixed_pt_const_type_AST!=null &&fixed_pt_const_type_AST.getFirstChild()!=null ?
				fixed_pt_const_type_AST.getFirstChild() : fixed_pt_const_type_AST;
			currentAST.advanceChildToEnd();
		}
		fixed_pt_const_type_AST = (AST)currentAST.root;
		returnAST = fixed_pt_const_type_AST;
	}
	
	public final void or_expr() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST or_expr_AST = null;
		Token  a = null;
		AST a_AST = null;
		
		xor_expr();
		if (inputState.guessing==0) {
			astFactory.addASTChild(currentAST, returnAST);
		}
		{
		switch ( LA(1)) {
		case OR:
		{
			a = LT(1);
			if (inputState.guessing==0) {
				a_AST = (AST)astFactory.create(a);
			}
			match(OR);
			or_expr();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			if ( inputState.guessing==0 ) {
				or_expr_AST = (AST)currentAST.root;
				
								or_expr_AST = (AST)astFactory.make( (new ASTArray(2)).add((AST)astFactory.create(CONST_EXP)).add(or_expr_AST));
								or_expr_AST.setText(a_AST.getText());
								((IDLEntityNode)or_expr_AST).setLine(((IDLEntityNode)a_AST).getLine());
							
				currentAST.root = or_expr_AST;
				currentAST.child = or_expr_AST!=null &&or_expr_AST.getFirstChild()!=null ?
					or_expr_AST.getFirstChild() : or_expr_AST;
				currentAST.advanceChildToEnd();
			}
			break;
		}
		case SEMI:
		case COLON:
		case COMMA:
		case RPAREN:
		case RBRACK:
		case GT:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		or_expr_AST = (AST)currentAST.root;
		returnAST = or_expr_AST;
	}
	
	public final void xor_expr() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST xor_expr_AST = null;
		Token  a = null;
		AST a_AST = null;
		
		and_expr();
		if (inputState.guessing==0) {
			astFactory.addASTChild(currentAST, returnAST);
		}
		{
		switch ( LA(1)) {
		case XOR:
		{
			a = LT(1);
			if (inputState.guessing==0) {
				a_AST = (AST)astFactory.create(a);
			}
			match(XOR);
			xor_expr();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			if ( inputState.guessing==0 ) {
				xor_expr_AST = (AST)currentAST.root;
					
								xor_expr_AST = (AST)astFactory.make( (new ASTArray(2)).add((AST)astFactory.create(CONST_EXP)).add(xor_expr_AST));
								xor_expr_AST.setText(a_AST.getText());
								((IDLEntityNode)xor_expr_AST).setLine(((IDLEntityNode)a_AST).getLine());
							
				currentAST.root = xor_expr_AST;
				currentAST.child = xor_expr_AST!=null &&xor_expr_AST.getFirstChild()!=null ?
					xor_expr_AST.getFirstChild() : xor_expr_AST;
				currentAST.advanceChildToEnd();
			}
			break;
		}
		case SEMI:
		case COLON:
		case COMMA:
		case OR:
		case RPAREN:
		case RBRACK:
		case GT:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		xor_expr_AST = (AST)currentAST.root;
		returnAST = xor_expr_AST;
	}
	
	public final void and_expr() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST and_expr_AST = null;
		Token  a = null;
		AST a_AST = null;
		
		shift_expr();
		if (inputState.guessing==0) {
			astFactory.addASTChild(currentAST, returnAST);
		}
		{
		switch ( LA(1)) {
		case AND:
		{
			a = LT(1);
			if (inputState.guessing==0) {
				a_AST = (AST)astFactory.create(a);
			}
			match(AND);
			and_expr();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			if ( inputState.guessing==0 ) {
				and_expr_AST = (AST)currentAST.root;
					
								and_expr_AST = (AST)astFactory.make( (new ASTArray(2)).add((AST)astFactory.create(CONST_EXP)).add(and_expr_AST));
								and_expr_AST.setText(a_AST.getText());
								((IDLEntityNode)and_expr_AST).setLine(((IDLEntityNode)a_AST).getLine());
							
				currentAST.root = and_expr_AST;
				currentAST.child = and_expr_AST!=null &&and_expr_AST.getFirstChild()!=null ?
					and_expr_AST.getFirstChild() : and_expr_AST;
				currentAST.advanceChildToEnd();
			}
			break;
		}
		case SEMI:
		case COLON:
		case COMMA:
		case OR:
		case XOR:
		case RPAREN:
		case RBRACK:
		case GT:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		and_expr_AST = (AST)currentAST.root;
		returnAST = and_expr_AST;
	}
	
	public final void shift_expr() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST shift_expr_AST = null;
		Token  a = null;
		AST a_AST = null;
		
		add_expr();
		if (inputState.guessing==0) {
			astFactory.addASTChild(currentAST, returnAST);
		}
		{
		switch ( LA(1)) {
		case SHIFT:
		{
			a = LT(1);
			if (inputState.guessing==0) {
				a_AST = (AST)astFactory.create(a);
			}
			match(SHIFT);
			shift_expr();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			if ( inputState.guessing==0 ) {
				shift_expr_AST = (AST)currentAST.root;
					
								shift_expr_AST = (AST)astFactory.make( (new ASTArray(2)).add((AST)astFactory.create(CONST_EXP)).add(shift_expr_AST));
								shift_expr_AST.setText(a_AST.getText());
								((IDLEntityNode)shift_expr_AST).setLine(((IDLEntityNode)a_AST).getLine());
							
				currentAST.root = shift_expr_AST;
				currentAST.child = shift_expr_AST!=null &&shift_expr_AST.getFirstChild()!=null ?
					shift_expr_AST.getFirstChild() : shift_expr_AST;
				currentAST.advanceChildToEnd();
			}
			break;
		}
		case SEMI:
		case COLON:
		case COMMA:
		case OR:
		case XOR:
		case AND:
		case RPAREN:
		case RBRACK:
		case GT:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		shift_expr_AST = (AST)currentAST.root;
		returnAST = shift_expr_AST;
	}
	
	public final void add_expr() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST add_expr_AST = null;
		Token  a = null;
		AST a_AST = null;
		
		mult_expr();
		if (inputState.guessing==0) {
			astFactory.addASTChild(currentAST, returnAST);
		}
		{
		switch ( LA(1)) {
		case ADD_OP:
		{
			a = LT(1);
			if (inputState.guessing==0) {
				a_AST = (AST)astFactory.create(a);
			}
			match(ADD_OP);
			add_expr();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			if ( inputState.guessing==0 ) {
				add_expr_AST = (AST)currentAST.root;
					
								add_expr_AST = (AST)astFactory.make( (new ASTArray(2)).add((AST)astFactory.create(CONST_EXP)).add(add_expr_AST));
								add_expr_AST.setText(a_AST.getText());
								((IDLEntityNode)add_expr_AST).setLine(((IDLEntityNode)a_AST).getLine());
							
				currentAST.root = add_expr_AST;
				currentAST.child = add_expr_AST!=null &&add_expr_AST.getFirstChild()!=null ?
					add_expr_AST.getFirstChild() : add_expr_AST;
				currentAST.advanceChildToEnd();
			}
			break;
		}
		case SEMI:
		case COLON:
		case COMMA:
		case OR:
		case XOR:
		case AND:
		case SHIFT:
		case RPAREN:
		case RBRACK:
		case GT:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		add_expr_AST = (AST)currentAST.root;
		returnAST = add_expr_AST;
	}
	
	public final void mult_expr() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST mult_expr_AST = null;
		Token  a = null;
		AST a_AST = null;
		
		unary_expr();
		if (inputState.guessing==0) {
			astFactory.addASTChild(currentAST, returnAST);
		}
		{
		switch ( LA(1)) {
		case MULT_OP:
		{
			a = LT(1);
			if (inputState.guessing==0) {
				a_AST = (AST)astFactory.create(a);
			}
			match(MULT_OP);
			mult_expr();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			if ( inputState.guessing==0 ) {
				mult_expr_AST = (AST)currentAST.root;
					
								mult_expr_AST = (AST)astFactory.make( (new ASTArray(2)).add((AST)astFactory.create(CONST_EXP)).add(mult_expr_AST));
								mult_expr_AST.setText(a_AST.getText());
								((IDLEntityNode)mult_expr_AST).setLine(((IDLEntityNode)a_AST).getLine());
							
				currentAST.root = mult_expr_AST;
				currentAST.child = mult_expr_AST!=null &&mult_expr_AST.getFirstChild()!=null ?
					mult_expr_AST.getFirstChild() : mult_expr_AST;
				currentAST.advanceChildToEnd();
			}
			break;
		}
		case SEMI:
		case COLON:
		case COMMA:
		case OR:
		case XOR:
		case AND:
		case SHIFT:
		case ADD_OP:
		case RPAREN:
		case RBRACK:
		case GT:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		mult_expr_AST = (AST)currentAST.root;
		returnAST = mult_expr_AST;
	}
	
	public final void unary_expr() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST unary_expr_AST = null;
		Token  a = null;
		AST a_AST = null;
		Token  b = null;
		AST b_AST = null;
		AST c_AST = null;
		
		switch ( LA(1)) {
		case ADD_OP:
		{
			a = LT(1);
			if (inputState.guessing==0) {
				a_AST = (AST)astFactory.create(a);
			}
			match(ADD_OP);
			primary_expr();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			if ( inputState.guessing==0 ) {
				unary_expr_AST = (AST)currentAST.root;
					
							unary_expr_AST = (AST)astFactory.make( (new ASTArray(2)).add((AST)astFactory.create(CONST_EXP)).add(unary_expr_AST));
							unary_expr_AST.setText(a_AST.getText());
							((IDLEntityNode)unary_expr_AST).setLine(((IDLEntityNode)a_AST).getLine());
						
				currentAST.root = unary_expr_AST;
				currentAST.child = unary_expr_AST!=null &&unary_expr_AST.getFirstChild()!=null ?
					unary_expr_AST.getFirstChild() : unary_expr_AST;
				currentAST.advanceChildToEnd();
			}
			unary_expr_AST = (AST)currentAST.root;
			break;
		}
		case TILDE:
		{
			b = LT(1);
			if (inputState.guessing==0) {
				b_AST = (AST)astFactory.create(b);
			}
			match(TILDE);
			primary_expr();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			if ( inputState.guessing==0 ) {
				unary_expr_AST = (AST)currentAST.root;
					
							unary_expr_AST = (AST)astFactory.make( (new ASTArray(2)).add((AST)astFactory.create(CONST_EXP)).add(unary_expr_AST));
							unary_expr_AST.setText(b_AST.getText());
							((IDLEntityNode)unary_expr_AST).setLine(((IDLEntityNode)b_AST).getLine());
						
				currentAST.root = unary_expr_AST;
				currentAST.child = unary_expr_AST!=null &&unary_expr_AST.getFirstChild()!=null ?
					unary_expr_AST.getFirstChild() : unary_expr_AST;
				currentAST.advanceChildToEnd();
			}
			unary_expr_AST = (AST)currentAST.root;
			break;
		}
		case SCOPEOP:
		case LPAREN:
		case INT:
		case OCTAL:
		case HEX:
		case STRING_LITERAL:
		case WSTRING_LITERAL:
		case FIXED_PT_LITERAL:
		case CHAR_LITERAL:
		case WCHAR_LITERAL:
		case FLOAT:
		case IDENT:
		case LITERAL_TRUE:
		case LITERAL_FALSE:
		{
			primary_expr();
			if (inputState.guessing==0) {
				c_AST = (AST)returnAST;
				astFactory.addASTChild(currentAST, returnAST);
			}
			unary_expr_AST = (AST)currentAST.root;
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		returnAST = unary_expr_AST;
	}
	
	public final void primary_expr() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST primary_expr_AST = null;
		AST a_AST = null;
		
		switch ( LA(1)) {
		case SCOPEOP:
		case IDENT:
		{
			scoped_name();
			if (inputState.guessing==0) {
				a_AST = (AST)returnAST;
				astFactory.addASTChild(currentAST, returnAST);
			}
			if ( inputState.guessing==0 ) {
				
							((IDLEntityNode)a_AST).setUsed(); 
						
			}
			primary_expr_AST = (AST)currentAST.root;
			break;
		}
		case INT:
		case OCTAL:
		case HEX:
		case STRING_LITERAL:
		case WSTRING_LITERAL:
		case FIXED_PT_LITERAL:
		case CHAR_LITERAL:
		case WCHAR_LITERAL:
		case FLOAT:
		case LITERAL_TRUE:
		case LITERAL_FALSE:
		{
			literal();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			primary_expr_AST = (AST)currentAST.root;
			break;
		}
		case LPAREN:
		{
			AST tmp37_AST = null;
			tmp37_AST = (AST)astFactory.create(LT(1));
			match(LPAREN);
			const_exp();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			AST tmp38_AST = null;
			tmp38_AST = (AST)astFactory.create(LT(1));
			match(RPAREN);
			primary_expr_AST = (AST)currentAST.root;
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		returnAST = primary_expr_AST;
	}
	
	public final void literal() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST literal_AST = null;
		AST a_AST = null;
		AST b_AST = null;
		AST i_AST = null;
		AST c_AST = null;
		AST k_AST = null;
		AST d_AST = null;
		AST e_AST = null;
		AST h_AST = null;
		
		switch ( LA(1)) {
		case INT:
		case OCTAL:
		case HEX:
		{
			integer_literal();
			if (inputState.guessing==0) {
				a_AST = (AST)returnAST;
			}
			if ( inputState.guessing==0 ) {
				literal_AST = (AST)currentAST.root;
				literal_AST = (AST)astFactory.make( (new ASTArray(2)).add((AST)astFactory.create(LITERAL)).add(literal_AST));
							literal_AST.setText(a_AST.getText());
				((IDLEntityNode)literal_AST).setLine(((IDLEntityNode)a_AST).getLine());
				((LiteralNode)literal_AST).setLiteralType(IDLTypeUtil.INTEGER);
						
				currentAST.root = literal_AST;
				currentAST.child = literal_AST!=null &&literal_AST.getFirstChild()!=null ?
					literal_AST.getFirstChild() : literal_AST;
				currentAST.advanceChildToEnd();
			}
			literal_AST = (AST)currentAST.root;
			break;
		}
		case STRING_LITERAL:
		{
			string_literal();
			if (inputState.guessing==0) {
				b_AST = (AST)returnAST;
			}
			if ( inputState.guessing==0 ) {
				literal_AST = (AST)currentAST.root;
				literal_AST = (AST)astFactory.make( (new ASTArray(2)).add((AST)astFactory.create(LITERAL)).add(literal_AST));
							literal_AST.setText(b_AST.getText());
				((IDLEntityNode)literal_AST).setLine(((IDLEntityNode)b_AST).getLine());
				((LiteralNode)literal_AST).setLiteralType(IDLTypeUtil.STRING);
						
				currentAST.root = literal_AST;
				currentAST.child = literal_AST!=null &&literal_AST.getFirstChild()!=null ?
					literal_AST.getFirstChild() : literal_AST;
				currentAST.advanceChildToEnd();
			}
			literal_AST = (AST)currentAST.root;
			break;
		}
		case WSTRING_LITERAL:
		{
			wstring_literal();
			if (inputState.guessing==0) {
				i_AST = (AST)returnAST;
			}
			if ( inputState.guessing==0 ) {
				literal_AST = (AST)currentAST.root;
				literal_AST = (AST)astFactory.make( (new ASTArray(2)).add((AST)astFactory.create(LITERAL)).add(literal_AST));
							literal_AST.setText(i_AST.getText());
				((IDLEntityNode)literal_AST).setLine(((IDLEntityNode)i_AST).getLine());
				((LiteralNode)literal_AST).setLiteralType(IDLTypeUtil.WSTRING);
						
				currentAST.root = literal_AST;
				currentAST.child = literal_AST!=null &&literal_AST.getFirstChild()!=null ?
					literal_AST.getFirstChild() : literal_AST;
				currentAST.advanceChildToEnd();
			}
			literal_AST = (AST)currentAST.root;
			break;
		}
		case CHAR_LITERAL:
		{
			character_literal();
			if (inputState.guessing==0) {
				c_AST = (AST)returnAST;
			}
			if ( inputState.guessing==0 ) {
				literal_AST = (AST)currentAST.root;
				literal_AST = (AST)astFactory.make( (new ASTArray(2)).add((AST)astFactory.create(LITERAL)).add(literal_AST));
							literal_AST.setText(c_AST.getText());
				((IDLEntityNode)literal_AST).setLine(((IDLEntityNode)c_AST).getLine());
				((LiteralNode)literal_AST).setLiteralType(IDLTypeUtil.CHAR);
						
				currentAST.root = literal_AST;
				currentAST.child = literal_AST!=null &&literal_AST.getFirstChild()!=null ?
					literal_AST.getFirstChild() : literal_AST;
				currentAST.advanceChildToEnd();
			}
			literal_AST = (AST)currentAST.root;
			break;
		}
		case WCHAR_LITERAL:
		{
			wcharacter_literal();
			if (inputState.guessing==0) {
				k_AST = (AST)returnAST;
			}
			if ( inputState.guessing==0 ) {
				literal_AST = (AST)currentAST.root;
				literal_AST = (AST)astFactory.make( (new ASTArray(2)).add((AST)astFactory.create(LITERAL)).add(literal_AST));
							literal_AST.setText(k_AST.getText());
				((IDLEntityNode)literal_AST).setLine(((IDLEntityNode)k_AST).getLine());
				((LiteralNode)literal_AST).setLiteralType(IDLTypeUtil.WCHAR);
						
				currentAST.root = literal_AST;
				currentAST.child = literal_AST!=null &&literal_AST.getFirstChild()!=null ?
					literal_AST.getFirstChild() : literal_AST;
				currentAST.advanceChildToEnd();
			}
			literal_AST = (AST)currentAST.root;
			break;
		}
		case FLOAT:
		{
			floating_pt_literal();
			if (inputState.guessing==0) {
				d_AST = (AST)returnAST;
			}
			if ( inputState.guessing==0 ) {
				literal_AST = (AST)currentAST.root;
				literal_AST = (AST)astFactory.make( (new ASTArray(2)).add((AST)astFactory.create(LITERAL)).add(literal_AST));
							literal_AST.setText(d_AST.getText());
				((IDLEntityNode)literal_AST).setLine(((IDLEntityNode)d_AST).getLine());
				((LiteralNode)literal_AST).setLiteralType(IDLTypeUtil.FLOAT);
						
				currentAST.root = literal_AST;
				currentAST.child = literal_AST!=null &&literal_AST.getFirstChild()!=null ?
					literal_AST.getFirstChild() : literal_AST;
				currentAST.advanceChildToEnd();
			}
			literal_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_TRUE:
		case LITERAL_FALSE:
		{
			boolean_literal();
			if (inputState.guessing==0) {
				e_AST = (AST)returnAST;
			}
			if ( inputState.guessing==0 ) {
				literal_AST = (AST)currentAST.root;
				literal_AST = (AST)astFactory.make( (new ASTArray(2)).add((AST)astFactory.create(LITERAL)).add(literal_AST));
							literal_AST.setText(e_AST.getText());
				((IDLEntityNode)literal_AST).setLine(((IDLEntityNode)e_AST).getLine());
				((LiteralNode)literal_AST).setLiteralType(IDLTypeUtil.BOOLEAN);
						
				currentAST.root = literal_AST;
				currentAST.child = literal_AST!=null &&literal_AST.getFirstChild()!=null ?
					literal_AST.getFirstChild() : literal_AST;
				currentAST.advanceChildToEnd();
			}
			literal_AST = (AST)currentAST.root;
			break;
		}
		case FIXED_PT_LITERAL:
		{
			fixed_pt_literal();
			if (inputState.guessing==0) {
				h_AST = (AST)returnAST;
			}
			if ( inputState.guessing==0 ) {
				literal_AST = (AST)currentAST.root;
				literal_AST = (AST)astFactory.make( (new ASTArray(2)).add((AST)astFactory.create(LITERAL)).add(literal_AST));
							literal_AST.setText(h_AST.getText());
				((IDLEntityNode)literal_AST).setLine(((IDLEntityNode)h_AST).getLine());
				((LiteralNode)literal_AST).setLiteralType(IDLTypeUtil.FIXED_CONST);
						
				currentAST.root = literal_AST;
				currentAST.child = literal_AST!=null &&literal_AST.getFirstChild()!=null ?
					literal_AST.getFirstChild() : literal_AST;
				currentAST.advanceChildToEnd();
			}
			literal_AST = (AST)currentAST.root;
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		returnAST = literal_AST;
	}
	
	public final void integer_literal() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST integer_literal_AST = null;
		
		switch ( LA(1)) {
		case INT:
		{
			AST tmp39_AST = null;
			if (inputState.guessing==0) {
				tmp39_AST = (AST)astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp39_AST);
			}
			match(INT);
			integer_literal_AST = (AST)currentAST.root;
			break;
		}
		case OCTAL:
		{
			AST tmp40_AST = null;
			if (inputState.guessing==0) {
				tmp40_AST = (AST)astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp40_AST);
			}
			match(OCTAL);
			integer_literal_AST = (AST)currentAST.root;
			break;
		}
		case HEX:
		{
			AST tmp41_AST = null;
			if (inputState.guessing==0) {
				tmp41_AST = (AST)astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp41_AST);
			}
			match(HEX);
			integer_literal_AST = (AST)currentAST.root;
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		returnAST = integer_literal_AST;
	}
	
	public final void string_literal() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST string_literal_AST = null;
		Token  a = null;
		AST a_AST = null;
		AST b_AST = null;
		
		a = LT(1);
		if (inputState.guessing==0) {
			a_AST = (AST)astFactory.create(a);
			astFactory.addASTChild(currentAST, a_AST);
		}
		match(STRING_LITERAL);
		{
		switch ( LA(1)) {
		case STRING_LITERAL:
		{
			string_literal();
			if (inputState.guessing==0) {
				b_AST = (AST)returnAST;
				astFactory.addASTChild(currentAST, returnAST);
			}
			if ( inputState.guessing==0 ) {
				
								a_AST.setText(a_AST.getText()+b_AST.getText());
							
			}
			break;
		}
		case SEMI:
		case COLON:
		case COMMA:
		case OR:
		case XOR:
		case AND:
		case SHIFT:
		case ADD_OP:
		case MULT_OP:
		case RPAREN:
		case RBRACK:
		case GT:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		string_literal_AST = (AST)currentAST.root;
		returnAST = string_literal_AST;
	}
	
	public final void wstring_literal() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST wstring_literal_AST = null;
		Token  a = null;
		AST a_AST = null;
		AST b_AST = null;
		
		a = LT(1);
		if (inputState.guessing==0) {
			a_AST = (AST)astFactory.create(a);
			astFactory.addASTChild(currentAST, a_AST);
		}
		match(WSTRING_LITERAL);
		{
		switch ( LA(1)) {
		case WSTRING_LITERAL:
		{
			wstring_literal();
			if (inputState.guessing==0) {
				b_AST = (AST)returnAST;
				astFactory.addASTChild(currentAST, returnAST);
			}
			if ( inputState.guessing==0 ) {
				
								a_AST.setText(a_AST.getText()+b_AST.getText());
							
			}
			break;
		}
		case SEMI:
		case COLON:
		case COMMA:
		case OR:
		case XOR:
		case AND:
		case SHIFT:
		case ADD_OP:
		case MULT_OP:
		case RPAREN:
		case RBRACK:
		case GT:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		wstring_literal_AST = (AST)currentAST.root;
		returnAST = wstring_literal_AST;
	}
	
	public final void character_literal() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST character_literal_AST = null;
		
		AST tmp42_AST = null;
		if (inputState.guessing==0) {
			tmp42_AST = (AST)astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp42_AST);
		}
		match(CHAR_LITERAL);
		character_literal_AST = (AST)currentAST.root;
		returnAST = character_literal_AST;
	}
	
	public final void wcharacter_literal() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST wcharacter_literal_AST = null;
		
		AST tmp43_AST = null;
		if (inputState.guessing==0) {
			tmp43_AST = (AST)astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp43_AST);
		}
		match(WCHAR_LITERAL);
		wcharacter_literal_AST = (AST)currentAST.root;
		returnAST = wcharacter_literal_AST;
	}
	
	public final void floating_pt_literal() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST floating_pt_literal_AST = null;
		
		AST tmp44_AST = null;
		if (inputState.guessing==0) {
			tmp44_AST = (AST)astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp44_AST);
		}
		match(FLOAT);
		floating_pt_literal_AST = (AST)currentAST.root;
		returnAST = floating_pt_literal_AST;
	}
	
	public final void boolean_literal() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST boolean_literal_AST = null;
		
		switch ( LA(1)) {
		case LITERAL_TRUE:
		{
			AST tmp45_AST = null;
			if (inputState.guessing==0) {
				tmp45_AST = (AST)astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp45_AST);
			}
			match(LITERAL_TRUE);
			boolean_literal_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_FALSE:
		{
			AST tmp46_AST = null;
			if (inputState.guessing==0) {
				tmp46_AST = (AST)astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp46_AST);
			}
			match(LITERAL_FALSE);
			boolean_literal_AST = (AST)currentAST.root;
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		returnAST = boolean_literal_AST;
	}
	
	public final void fixed_pt_literal() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST fixed_pt_literal_AST = null;
		
		AST tmp47_AST = null;
		if (inputState.guessing==0) {
			tmp47_AST = (AST)astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp47_AST);
		}
		match(FIXED_PT_LITERAL);
		fixed_pt_literal_AST = (AST)currentAST.root;
		returnAST = fixed_pt_literal_AST;
	}
	
	public final void context_string_literal() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST context_string_literal_AST = null;
		Token  a = null;
		AST a_AST = null;
		
		a = LT(1);
		if (inputState.guessing==0) {
			a_AST = (AST)astFactory.create(a);
		}
		match(STRING_LITERAL);
		if ( inputState.guessing==0 ) {
			context_string_literal_AST = (AST)currentAST.root;
			
						context_string_literal_AST = (AST)astFactory.make( (new ASTArray(2)).add((AST)astFactory.create(LITERAL)).add(context_string_literal_AST));
			context_string_literal_AST.setText(a_AST.getText());
			((IDLEntityNode)context_string_literal_AST).setLine(((IDLEntityNode)a_AST).getLine());
			((LiteralNode)context_string_literal_AST).setLiteralType(IDLTypeUtil.STRING);
					
			currentAST.root = context_string_literal_AST;
			currentAST.child = context_string_literal_AST!=null &&context_string_literal_AST.getFirstChild()!=null ?
				context_string_literal_AST.getFirstChild() : context_string_literal_AST;
			currentAST.advanceChildToEnd();
		}
		context_string_literal_AST = (AST)currentAST.root;
		returnAST = context_string_literal_AST;
	}
	
	public final void const_exp_in_brackets() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST const_exp_in_brackets_AST = null;
		
		AST tmp48_AST = null;
		tmp48_AST = (AST)astFactory.create(LT(1));
		match(LBRACK);
		const_exp();
		if (inputState.guessing==0) {
			astFactory.addASTChild(currentAST, returnAST);
		}
		AST tmp49_AST = null;
		tmp49_AST = (AST)astFactory.create(LT(1));
		match(RBRACK);
		const_exp_in_brackets_AST = (AST)currentAST.root;
		returnAST = const_exp_in_brackets_AST;
	}
	
	public final void array_decl() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST array_decl_AST = null;
		AST a_AST = null;
		
			AST down;//
			ArrayNode newNode, begin = null;
		
		
		{
		_loop65:
		do {
			if ((LA(1)==LBRACK)) {
				const_exp_in_brackets();
				if (inputState.guessing==0) {
					a_AST = (AST)returnAST;
				}
				if ( inputState.guessing==0 ) {
					array_decl_AST = (AST)currentAST.root;
					
									newNode = new ArrayNode();
									newNode.setLine(((IDLEntityNode)a_AST).getLine());
									newNode.setFirstChild(a_AST);
									if(array_decl_AST != null) {
										down = array_decl_AST.getFirstChild();//
										while(down.getNextSibling() != null) down = down.getNextSibling().getFirstChild();//
										down.setNextSibling(newNode);//
										//newNode.addChild(#array_decl);
										((IDLEntityNode)array_decl_AST).setUsed();
									}
									else array_decl_AST = newNode;//
									//#array_decl = newNode;
								
					currentAST.root = array_decl_AST;
					currentAST.child = array_decl_AST!=null &&array_decl_AST.getFirstChild()!=null ?
						array_decl_AST.getFirstChild() : array_decl_AST;
					currentAST.advanceChildToEnd();
				}
			}
			else {
				break _loop65;
			}
			
		} while (true);
		}
		array_decl_AST = (AST)currentAST.root;
		returnAST = array_decl_AST;
	}
	
	public final void type_spec() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST type_spec_AST = null;
		
		switch ( LA(1)) {
		case STRING:
		case FIXED:
		case WSTRING:
		case SEQUENCE:
		case SCOPEOP:
		case IDENT:
		case LITERAL_float:
		case LITERAL_double:
		case LITERAL_long:
		case LITERAL_short:
		case LITERAL_unsigned:
		case LITERAL_char:
		case LITERAL_wchar:
		case LITERAL_any:
		case LITERAL_Object:
		case LITERAL_ValueBase:
		case LITERAL_octet:
		case LITERAL_boolean:
		{
			simple_type_spec();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			type_spec_AST = (AST)currentAST.root;
			break;
		}
		case STRUCTURE:
		{
			struct_type();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			type_spec_AST = (AST)currentAST.root;
			break;
		}
		case UNION:
		{
			union_type();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			type_spec_AST = (AST)currentAST.root;
			break;
		}
		case ENUM:
		{
			enum_type();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			type_spec_AST = (AST)currentAST.root;
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		returnAST = type_spec_AST;
	}
	
	public final void struct_type() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST struct_type_AST = null;
		AST name_AST = null;
		
		StructNode tmp50_AST = null;
		if (inputState.guessing==0) {
			tmp50_AST = new StructNode(LT(1));
			astFactory.makeASTRoot(currentAST, tmp50_AST);
		}
		match(STRUCTURE);
		identifier();
		if (inputState.guessing==0) {
			name_AST = (AST)returnAST;
		}
		AST tmp51_AST = null;
		tmp51_AST = (AST)astFactory.create(LT(1));
		match(LCURLY);
		{
		int _cnt77=0;
		_loop77:
		do {
			if ((_tokenSet_1.member(LA(1)))) {
				member();
				if (inputState.guessing==0) {
					astFactory.addASTChild(currentAST, returnAST);
				}
			}
			else {
				if ( _cnt77>=1 ) { break _loop77; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt77++;
		} while (true);
		}
		AST tmp52_AST = null;
		tmp52_AST = (AST)astFactory.create(LT(1));
		match(RCURLY);
		if ( inputState.guessing==0 ) {
			
						tmp50_AST.setText(name_AST.getText());
					
		}
		struct_type_AST = (AST)currentAST.root;
		returnAST = struct_type_AST;
	}
	
	public final void union_type() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST union_type_AST = null;
		AST name_AST = null;
		AST a_AST = null;
		
		UnionNode tmp53_AST = null;
		if (inputState.guessing==0) {
			tmp53_AST = new UnionNode(LT(1));
			astFactory.makeASTRoot(currentAST, tmp53_AST);
		}
		match(UNION);
		identifier();
		if (inputState.guessing==0) {
			name_AST = (AST)returnAST;
		}
		AST tmp54_AST = null;
		tmp54_AST = (AST)astFactory.create(LT(1));
		match(LITERAL_switch);
		AST tmp55_AST = null;
		tmp55_AST = (AST)astFactory.create(LT(1));
		match(LPAREN);
		switch_type_spec();
		if (inputState.guessing==0) {
			a_AST = (AST)returnAST;
			astFactory.addASTChild(currentAST, returnAST);
		}
		AST tmp56_AST = null;
		tmp56_AST = (AST)astFactory.create(LT(1));
		match(RPAREN);
		AST tmp57_AST = null;
		tmp57_AST = (AST)astFactory.create(LT(1));
		match(LCURLY);
		switch_body();
		if (inputState.guessing==0) {
			astFactory.addASTChild(currentAST, returnAST);
		}
		AST tmp58_AST = null;
		tmp58_AST = (AST)astFactory.create(LT(1));
		match(RCURLY);
		if ( inputState.guessing==0 ) {
			
						tmp53_AST.setText(name_AST.getText());
						((IDLEntityNode)a_AST).setUsed();
					
		}
		union_type_AST = (AST)currentAST.root;
		returnAST = union_type_AST;
	}
	
	public final void enum_type() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST enum_type_AST = null;
		AST name_AST = null;
		
		EnumNode tmp59_AST = null;
		if (inputState.guessing==0) {
			tmp59_AST = new EnumNode(LT(1));
			astFactory.makeASTRoot(currentAST, tmp59_AST);
		}
		match(ENUM);
		identifier();
		if (inputState.guessing==0) {
			name_AST = (AST)returnAST;
		}
		AST tmp60_AST = null;
		tmp60_AST = (AST)astFactory.create(LT(1));
		match(LCURLY);
		identifier();
		if (inputState.guessing==0) {
			astFactory.addASTChild(currentAST, returnAST);
		}
		{
		_loop91:
		do {
			if ((LA(1)==COMMA)) {
				AST tmp61_AST = null;
				tmp61_AST = (AST)astFactory.create(LT(1));
				match(COMMA);
				identifier();
				if (inputState.guessing==0) {
					astFactory.addASTChild(currentAST, returnAST);
				}
			}
			else {
				break _loop91;
			}
			
		} while (true);
		}
		AST tmp62_AST = null;
		tmp62_AST = (AST)astFactory.create(LT(1));
		match(RCURLY);
		if ( inputState.guessing==0 ) {
			
						tmp59_AST.setText(name_AST.getText());
					
		}
		enum_type_AST = (AST)currentAST.root;
		returnAST = enum_type_AST;
	}
	
	public final void type_declarator() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST type_declarator_AST = null;
		AST a_AST = null;
		AST d_AST = null;
		AST e_AST = null;
		AST b_AST = null;
		AST c_AST = null;
		
			TypeDeclNode newNode, current = null;
			TypeDeclNode begin = null;
			AST down;
		
		
		type_spec();
		if (inputState.guessing==0) {
			a_AST = (AST)returnAST;
		}
		identifier();
		if (inputState.guessing==0) {
			d_AST = (AST)returnAST;
		}
		array_decl();
		if (inputState.guessing==0) {
			e_AST = (AST)returnAST;
		}
		{
		_loop71:
		do {
			if ((LA(1)==COMMA)) {
				AST tmp63_AST = null;
				tmp63_AST = (AST)astFactory.create(LT(1));
				match(COMMA);
				identifier();
				if (inputState.guessing==0) {
					b_AST = (AST)returnAST;
				}
				array_decl();
				if (inputState.guessing==0) {
					c_AST = (AST)returnAST;
				}
				if ( inputState.guessing==0 ) {
					
									newNode = new TypeDeclNode();
									((IDLEntityNode)a_AST).setUsed();
									newNode.setLine(((IDLEntityNode)b_AST).getLine());
									newNode.setText(b_AST.getText());
									if(c_AST == null) newNode.addChild(astFactory.dupTree(a_AST)); 
									else {
										/* The following part adds the type_spec to the end of the 
										   array_decl i.e. adds the given type to the array. */
										((IDLEntityNode)c_AST).setUsed();
										newNode.addChild(c_AST);
										down = c_AST.getFirstChild();
										while(down.getNextSibling() != null) down = down.getNextSibling().getFirstChild();
										down.setNextSibling(astFactory.dupTree(a_AST));
									}
									if(begin == null) begin = newNode;
									else current.setNextSibling(newNode);
									current = newNode;
								
				}
			}
			else {
				break _loop71;
			}
			
		} while (true);
		}
		if ( inputState.guessing==0 ) {
			type_declarator_AST = (AST)currentAST.root;
			
						type_declarator_AST = (AST)astFactory.make( (new ASTArray(2)).add((AST)astFactory.create(TYPE_DECL)).add(type_declarator_AST));
						((IDLEntityNode)a_AST).setUsed();
						((IDLEntityNode)type_declarator_AST).setLine(((IDLEntityNode)d_AST).getLine());
						type_declarator_AST.setText(d_AST.getText());
						if(e_AST == null) type_declarator_AST.addChild(a_AST);
						else  {
							/* The following part adds the type_spec to the end of the 
							   array_decl i.e. adds the given type to the array. */
							((IDLEntityNode)e_AST).setUsed();
							type_declarator_AST.addChild(e_AST);
							down = e_AST.getFirstChild();
							while(down.getNextSibling() != null) down = down.getNextSibling().getFirstChild();
							down.setNextSibling(a_AST);
						}  
			if(begin != null) type_declarator_AST.setNextSibling(begin); 
					
			currentAST.root = type_declarator_AST;
			currentAST.child = type_declarator_AST!=null &&type_declarator_AST.getFirstChild()!=null ?
				type_declarator_AST.getFirstChild() : type_declarator_AST;
			currentAST.advanceChildToEnd();
		}
		type_declarator_AST = (AST)currentAST.root;
		returnAST = type_declarator_AST;
	}
	
	public final void simple_type_spec() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST simple_type_spec_AST = null;
		
		switch ( LA(1)) {
		case LITERAL_float:
		case LITERAL_double:
		case LITERAL_long:
		case LITERAL_short:
		case LITERAL_unsigned:
		case LITERAL_char:
		case LITERAL_wchar:
		case LITERAL_any:
		case LITERAL_Object:
		case LITERAL_ValueBase:
		case LITERAL_octet:
		case LITERAL_boolean:
		{
			base_type_spec();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			simple_type_spec_AST = (AST)currentAST.root;
			break;
		}
		case SEQUENCE:
		{
			sequence_type();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			simple_type_spec_AST = (AST)currentAST.root;
			break;
		}
		case STRING:
		{
			string_type();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			simple_type_spec_AST = (AST)currentAST.root;
			break;
		}
		case WSTRING:
		{
			wide_string_type();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			simple_type_spec_AST = (AST)currentAST.root;
			break;
		}
		case FIXED:
		{
			fixed_pt_type();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			simple_type_spec_AST = (AST)currentAST.root;
			break;
		}
		case SCOPEOP:
		case IDENT:
		{
			scoped_name();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			simple_type_spec_AST = (AST)currentAST.root;
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		returnAST = simple_type_spec_AST;
	}
	
	public final void base_type_spec() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST base_type_spec_AST = null;
		
		switch ( LA(1)) {
		case LITERAL_float:
		case LITERAL_double:
		case LITERAL_long:
		case LITERAL_short:
		case LITERAL_unsigned:
		{
			int_or_float();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			base_type_spec_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_char:
		{
			char_type();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			base_type_spec_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_wchar:
		{
			wide_char_type();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			base_type_spec_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_boolean:
		{
			boolean_type();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			base_type_spec_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_octet:
		{
			octet_type();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			base_type_spec_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_any:
		{
			any_type();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			base_type_spec_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_Object:
		{
			object_type();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			base_type_spec_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_ValueBase:
		{
			valuebase_type();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			base_type_spec_AST = (AST)currentAST.root;
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		returnAST = base_type_spec_AST;
	}
	
	public final void sequence_type() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST sequence_type_AST = null;
		AST a_AST = null;
		
		SequenceNode tmp64_AST = null;
		if (inputState.guessing==0) {
			tmp64_AST = new SequenceNode(LT(1));
			astFactory.makeASTRoot(currentAST, tmp64_AST);
		}
		match(SEQUENCE);
		AST tmp65_AST = null;
		tmp65_AST = (AST)astFactory.create(LT(1));
		match(LT);
		simple_type_spec();
		if (inputState.guessing==0) {
			a_AST = (AST)returnAST;
			astFactory.addASTChild(currentAST, returnAST);
		}
		{
		switch ( LA(1)) {
		case COMMA:
		{
			AST tmp66_AST = null;
			tmp66_AST = (AST)astFactory.create(LT(1));
			match(COMMA);
			const_exp();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			break;
		}
		case GT:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		AST tmp67_AST = null;
		tmp67_AST = (AST)astFactory.create(LT(1));
		match(GT);
		if ( inputState.guessing==0 ) {
			
						((IDLEntityNode)a_AST).setUsed();
					
		}
		sequence_type_AST = (AST)currentAST.root;
		returnAST = sequence_type_AST;
	}
	
	public final void fixed_pt_type() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST fixed_pt_type_AST = null;
		AST a_AST = null;
		
		FixedNode tmp68_AST = null;
		if (inputState.guessing==0) {
			tmp68_AST = new FixedNode(LT(1));
			astFactory.makeASTRoot(currentAST, tmp68_AST);
		}
		match(FIXED);
		AST tmp69_AST = null;
		tmp69_AST = (AST)astFactory.create(LT(1));
		match(LT);
		const_exp();
		if (inputState.guessing==0) {
			astFactory.addASTChild(currentAST, returnAST);
		}
		AST tmp70_AST = null;
		tmp70_AST = (AST)astFactory.create(LT(1));
		match(COMMA);
		integer_literal();
		if (inputState.guessing==0) {
			a_AST = (AST)returnAST;
		}
		AST tmp71_AST = null;
		tmp71_AST = (AST)astFactory.create(LT(1));
		match(GT);
		if ( inputState.guessing==0 ) {
			fixed_pt_type_AST = (AST)currentAST.root;
			IDLEntityNode literalNode  = new LiteralNode();
						literalNode.setText(a_AST.getText());
			literalNode.setLine(((IDLEntityNode)a_AST).getLine());
			((LiteralNode)literalNode).setLiteralType(IDLTypeUtil.INTEGER);
						fixed_pt_type_AST.addChild(literalNode);
					
		}
		fixed_pt_type_AST = (AST)currentAST.root;
		returnAST = fixed_pt_type_AST;
	}
	
	public final void octet_type() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST octet_type_AST = null;
		Token  a = null;
		AST a_AST = null;
		
		a = LT(1);
		if (inputState.guessing==0) {
			a_AST = (AST)astFactory.create(a);
		}
		match(LITERAL_octet);
		if ( inputState.guessing==0 ) {
			octet_type_AST = (AST)currentAST.root;
			
			octet_type_AST = (AST)astFactory.make( (new ASTArray(2)).add((AST)astFactory.create(BASETYPE)).add(octet_type_AST));
			octet_type_AST.setText("octet");
						((IDLEntityNode)octet_type_AST).setLine(((IDLEntityNode)a_AST).getLine());
					
			currentAST.root = octet_type_AST;
			currentAST.child = octet_type_AST!=null &&octet_type_AST.getFirstChild()!=null ?
				octet_type_AST.getFirstChild() : octet_type_AST;
			currentAST.advanceChildToEnd();
		}
		octet_type_AST = (AST)currentAST.root;
		returnAST = octet_type_AST;
	}
	
	public final void any_type() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST any_type_AST = null;
		Token  a = null;
		AST a_AST = null;
		
		a = LT(1);
		if (inputState.guessing==0) {
			a_AST = (AST)astFactory.create(a);
		}
		match(LITERAL_any);
		if ( inputState.guessing==0 ) {
			any_type_AST = (AST)currentAST.root;
			
						any_type_AST = (AST)astFactory.make( (new ASTArray(2)).add((AST)astFactory.create(BASETYPE)).add(any_type_AST));
						any_type_AST.setText("any");
						((IDLEntityNode)any_type_AST).setLine(((IDLEntityNode)a_AST).getLine()); 
					
			currentAST.root = any_type_AST;
			currentAST.child = any_type_AST!=null &&any_type_AST.getFirstChild()!=null ?
				any_type_AST.getFirstChild() : any_type_AST;
			currentAST.advanceChildToEnd();
		}
		any_type_AST = (AST)currentAST.root;
		returnAST = any_type_AST;
	}
	
	public final void object_type() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST object_type_AST = null;
		Token  a = null;
		AST a_AST = null;
		
		a = LT(1);
		if (inputState.guessing==0) {
			a_AST = (AST)astFactory.create(a);
		}
		match(LITERAL_Object);
		if ( inputState.guessing==0 ) {
			object_type_AST = (AST)currentAST.root;
			
						object_type_AST = (AST)astFactory.make( (new ASTArray(2)).add((AST)astFactory.create(BASETYPE)).add(object_type_AST));
			object_type_AST.setText("Object");
						((IDLEntityNode)object_type_AST).setLine(((IDLEntityNode)a_AST).getLine()); 
					
			currentAST.root = object_type_AST;
			currentAST.child = object_type_AST!=null &&object_type_AST.getFirstChild()!=null ?
				object_type_AST.getFirstChild() : object_type_AST;
			currentAST.advanceChildToEnd();
		}
		object_type_AST = (AST)currentAST.root;
		returnAST = object_type_AST;
	}
	
	public final void valuebase_type() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST valuebase_type_AST = null;
		Token  a = null;
		AST a_AST = null;
		
		a = LT(1);
		if (inputState.guessing==0) {
			a_AST = (AST)astFactory.create(a);
		}
		match(LITERAL_ValueBase);
		if ( inputState.guessing==0 ) {
			valuebase_type_AST = (AST)currentAST.root;
			
			valuebase_type_AST = (AST)astFactory.make( (new ASTArray(2)).add((AST)astFactory.create(BASETYPE)).add(valuebase_type_AST));
			valuebase_type_AST.setText("ValueBase");
			((IDLEntityNode)valuebase_type_AST).setLine(((IDLEntityNode)a_AST).getLine());
			
			currentAST.root = valuebase_type_AST;
			currentAST.child = valuebase_type_AST!=null &&valuebase_type_AST.getFirstChild()!=null ?
				valuebase_type_AST.getFirstChild() : valuebase_type_AST;
			currentAST.advanceChildToEnd();
		}
		valuebase_type_AST = (AST)currentAST.root;
		returnAST = valuebase_type_AST;
	}
	
	public final void member() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST member_AST = null;
		
		type_declarator();
		if (inputState.guessing==0) {
			astFactory.addASTChild(currentAST, returnAST);
		}
		AST tmp72_AST = null;
		tmp72_AST = (AST)astFactory.create(LT(1));
		match(SEMI);
		member_AST = (AST)currentAST.root;
		returnAST = member_AST;
	}
	
	public final void switch_type_spec() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST switch_type_spec_AST = null;
		
		switch ( LA(1)) {
		case LITERAL_long:
		case LITERAL_short:
		case LITERAL_unsigned:
		{
			integer_type();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			switch_type_spec_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_char:
		{
			char_type();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			switch_type_spec_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_boolean:
		{
			boolean_type();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			switch_type_spec_AST = (AST)currentAST.root;
			break;
		}
		case ENUM:
		{
			enum_type();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			switch_type_spec_AST = (AST)currentAST.root;
			break;
		}
		case SCOPEOP:
		case IDENT:
		{
			scoped_name();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			switch_type_spec_AST = (AST)currentAST.root;
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		returnAST = switch_type_spec_AST;
	}
	
	public final void switch_body() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST switch_body_AST = null;
		
		{
		int _cnt83=0;
		_loop83:
		do {
			if ((LA(1)==LITERAL_case||LA(1)==LITERAL_default)) {
				case_expr();
				if (inputState.guessing==0) {
					astFactory.addASTChild(currentAST, returnAST);
				}
			}
			else {
				if ( _cnt83>=1 ) { break _loop83; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt83++;
		} while (true);
		}
		switch_body_AST = (AST)currentAST.root;
		returnAST = switch_body_AST;
	}
	
	public final void integer_type() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST integer_type_AST = null;
		Token  x = null;
		AST x_AST = null;
		Token  a = null;
		AST a_AST = null;
		Token  y = null;
		AST y_AST = null;
		Token  z = null;
		AST z_AST = null;
		Token  b = null;
		AST b_AST = null;
		Token  c = null;
		AST c_AST = null;
		Token  d = null;
		AST d_AST = null;
		
		switch ( LA(1)) {
		case LITERAL_short:
		{
			x = LT(1);
			if (inputState.guessing==0) {
				x_AST = (AST)astFactory.create(x);
			}
			match(LITERAL_short);
			if ( inputState.guessing==0 ) {
				integer_type_AST = (AST)currentAST.root;
				
							integer_type_AST = (AST)astFactory.make( (new ASTArray(2)).add((AST)astFactory.create(BASETYPE)).add(integer_type_AST));
					        integer_type_AST.setText("short");
							((IDLEntityNode)integer_type_AST).setLine(((IDLEntityNode)x_AST).getLine());    
						
				currentAST.root = integer_type_AST;
				currentAST.child = integer_type_AST!=null &&integer_type_AST.getFirstChild()!=null ?
					integer_type_AST.getFirstChild() : integer_type_AST;
				currentAST.advanceChildToEnd();
			}
			integer_type_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_long:
		{
			a = LT(1);
			if (inputState.guessing==0) {
				a_AST = (AST)astFactory.create(a);
			}
			match(LITERAL_long);
			{
			switch ( LA(1)) {
			case LITERAL_long:
			{
				y = LT(1);
				if (inputState.guessing==0) {
					y_AST = (AST)astFactory.create(y);
				}
				match(LITERAL_long);
				break;
			}
			case SEMI:
			case COMMA:
			case RPAREN:
			case IDENT:
			case GT:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			if ( inputState.guessing==0 ) {
				integer_type_AST = (AST)currentAST.root;
				
							integer_type_AST = (AST)astFactory.make( (new ASTArray(2)).add((AST)astFactory.create(BASETYPE)).add(integer_type_AST));
							if(y_AST != null) integer_type_AST.setText("long_long"); 
							else integer_type_AST.setText("long");
							((IDLEntityNode)integer_type_AST).setLine(((IDLEntityNode)a_AST).getLine()); 
						
				currentAST.root = integer_type_AST;
				currentAST.child = integer_type_AST!=null &&integer_type_AST.getFirstChild()!=null ?
					integer_type_AST.getFirstChild() : integer_type_AST;
				currentAST.advanceChildToEnd();
			}
			integer_type_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_unsigned:
		{
			z = LT(1);
			if (inputState.guessing==0) {
				z_AST = (AST)astFactory.create(z);
			}
			match(LITERAL_unsigned);
			{
			switch ( LA(1)) {
			case LITERAL_short:
			{
				b = LT(1);
				if (inputState.guessing==0) {
					b_AST = (AST)astFactory.create(b);
				}
				match(LITERAL_short);
				break;
			}
			case LITERAL_long:
			{
				c = LT(1);
				if (inputState.guessing==0) {
					c_AST = (AST)astFactory.create(c);
				}
				match(LITERAL_long);
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			{
			switch ( LA(1)) {
			case LITERAL_long:
			{
				d = LT(1);
				if (inputState.guessing==0) {
					d_AST = (AST)astFactory.create(d);
				}
				match(LITERAL_long);
				break;
			}
			case SEMI:
			case COMMA:
			case RPAREN:
			case IDENT:
			case GT:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			if ( inputState.guessing==0 ) {
				integer_type_AST = (AST)currentAST.root;
				
							String type = null;
							if((b_AST != null) && (d_AST != null)) {
								System.out.println("error(line "+
									((IDLEntityNode)b_AST).getLine()+"): there is no data type unsigned short long");
								System.exit(0);
							}
							if(b_AST != null) {
								type = "unsigned_short"; 
							}
							if(c_AST != null) {
								type = "unsigned_long";
							}
							if(d_AST != null) type = type.concat("_long");
							integer_type_AST = (AST)astFactory.make( (new ASTArray(2)).add((AST)astFactory.create(BASETYPE)).add(integer_type_AST)); 
							integer_type_AST.setText(type);
							((IDLEntityNode)integer_type_AST).setLine(((IDLEntityNode)z_AST).getLine()); 
						
				currentAST.root = integer_type_AST;
				currentAST.child = integer_type_AST!=null &&integer_type_AST.getFirstChild()!=null ?
					integer_type_AST.getFirstChild() : integer_type_AST;
				currentAST.advanceChildToEnd();
			}
			integer_type_AST = (AST)currentAST.root;
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		returnAST = integer_type_AST;
	}
	
	public final void case_expr() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST case_expr_AST = null;
		AST a_AST = null;
		AST b_AST = null;
		AST c_AST = null;
		AST d_AST = null;
		
			AST down;
		
		
		case_labels();
		if (inputState.guessing==0) {
			a_AST = (AST)returnAST;
		}
		type_spec();
		if (inputState.guessing==0) {
			b_AST = (AST)returnAST;
		}
		identifier();
		if (inputState.guessing==0) {
			c_AST = (AST)returnAST;
		}
		array_decl();
		if (inputState.guessing==0) {
			d_AST = (AST)returnAST;
		}
		AST tmp73_AST = null;
		tmp73_AST = (AST)astFactory.create(LT(1));
		match(SEMI);
		if ( inputState.guessing==0 ) {
			case_expr_AST = (AST)currentAST.root;
			
			case_expr_AST = (AST)astFactory.make( (new ASTArray(2)).add((AST)astFactory.create(CASE_EXP)).add(case_expr_AST));
						case_expr_AST.setText(c_AST.getText());
						((IDLEntityNode)b_AST).setUsed();
						if(d_AST == null) case_expr_AST.setFirstChild(b_AST);
						else  {
							/* The following part adds the type_spec to the end of the 
							   array_decl i.e. adds the given type to the array. */
							((IDLEntityNode)d_AST).setUsed();
							case_expr_AST.setFirstChild(d_AST);
							down = d_AST.getFirstChild();
							while(down.getNextSibling() != null) down = down.getNextSibling().getFirstChild();
							down.setNextSibling(b_AST);
						}
						case_expr_AST.addChild(a_AST);
			((IDLEntityNode)case_expr_AST).setLine(((IDLEntityNode)b_AST).getLine());
						
					
			currentAST.root = case_expr_AST;
			currentAST.child = case_expr_AST!=null &&case_expr_AST.getFirstChild()!=null ?
				case_expr_AST.getFirstChild() : case_expr_AST;
			currentAST.advanceChildToEnd();
		}
		case_expr_AST = (AST)currentAST.root;
		returnAST = case_expr_AST;
	}
	
	public final void case_labels() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST case_labels_AST = null;
		
		{
		int _cnt87=0;
		_loop87:
		do {
			if ((LA(1)==LITERAL_case||LA(1)==LITERAL_default)) {
				case_label();
				if (inputState.guessing==0) {
					astFactory.addASTChild(currentAST, returnAST);
				}
			}
			else {
				if ( _cnt87>=1 ) { break _loop87; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt87++;
		} while (true);
		}
		case_labels_AST = (AST)currentAST.root;
		returnAST = case_labels_AST;
	}
	
	public final void case_label() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST case_label_AST = null;
		
		switch ( LA(1)) {
		case LITERAL_case:
		{
			AST tmp74_AST = null;
			tmp74_AST = (AST)astFactory.create(LT(1));
			match(LITERAL_case);
			const_exp();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			AST tmp75_AST = null;
			tmp75_AST = (AST)astFactory.create(LT(1));
			match(COLON);
			case_label_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_default:
		{
			AST tmp76_AST = null;
			if (inputState.guessing==0) {
				tmp76_AST = (AST)astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp76_AST);
			}
			match(LITERAL_default);
			AST tmp77_AST = null;
			tmp77_AST = (AST)astFactory.create(LT(1));
			match(COLON);
			case_label_AST = (AST)currentAST.root;
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		returnAST = case_label_AST;
	}
	
	public final void param_type_spec() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST param_type_spec_AST = null;
		
		switch ( LA(1)) {
		case LITERAL_float:
		case LITERAL_double:
		case LITERAL_long:
		case LITERAL_short:
		case LITERAL_unsigned:
		case LITERAL_char:
		case LITERAL_wchar:
		case LITERAL_any:
		case LITERAL_Object:
		case LITERAL_ValueBase:
		case LITERAL_octet:
		case LITERAL_boolean:
		{
			base_type_spec();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			param_type_spec_AST = (AST)currentAST.root;
			break;
		}
		case STRING:
		{
			string_type();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			param_type_spec_AST = (AST)currentAST.root;
			break;
		}
		case WSTRING:
		{
			wide_string_type();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			param_type_spec_AST = (AST)currentAST.root;
			break;
		}
		case FIXED:
		{
			fixed_pt_type();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			param_type_spec_AST = (AST)currentAST.root;
			break;
		}
		case SCOPEOP:
		case IDENT:
		{
			scoped_name();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			param_type_spec_AST = (AST)currentAST.root;
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		returnAST = param_type_spec_AST;
	}
	
	public final void op_type_spec() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST op_type_spec_AST = null;
		
		switch ( LA(1)) {
		case LITERAL_void:
		{
			void_type();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			op_type_spec_AST = (AST)currentAST.root;
			break;
		}
		case STRING:
		case FIXED:
		case WSTRING:
		case SCOPEOP:
		case IDENT:
		case LITERAL_float:
		case LITERAL_double:
		case LITERAL_long:
		case LITERAL_short:
		case LITERAL_unsigned:
		case LITERAL_char:
		case LITERAL_wchar:
		case LITERAL_any:
		case LITERAL_Object:
		case LITERAL_ValueBase:
		case LITERAL_octet:
		case LITERAL_boolean:
		{
			param_type_spec();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			op_type_spec_AST = (AST)currentAST.root;
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		returnAST = op_type_spec_AST;
	}
	
	public final void parameter_dcls() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST parameter_dcls_AST = null;
		
		AST tmp78_AST = null;
		tmp78_AST = (AST)astFactory.create(LT(1));
		match(LPAREN);
		{
		switch ( LA(1)) {
		case LITERAL_in:
		case LITERAL_out:
		case LITERAL_inout:
		{
			param_dcl();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			{
			_loop113:
			do {
				if ((LA(1)==COMMA)) {
					AST tmp79_AST = null;
					tmp79_AST = (AST)astFactory.create(LT(1));
					match(COMMA);
					param_dcl();
					if (inputState.guessing==0) {
						astFactory.addASTChild(currentAST, returnAST);
					}
				}
				else {
					break _loop113;
				}
				
			} while (true);
			}
			break;
		}
		case RPAREN:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		AST tmp80_AST = null;
		tmp80_AST = (AST)astFactory.create(LT(1));
		match(RPAREN);
		parameter_dcls_AST = (AST)currentAST.root;
		returnAST = parameter_dcls_AST;
	}
	
	public final void raises_expr() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST raises_expr_AST = null;
		
		RaisesNode tmp81_AST = null;
		if (inputState.guessing==0) {
			tmp81_AST = new RaisesNode(LT(1));
			astFactory.makeASTRoot(currentAST, tmp81_AST);
		}
		match(RAISES);
		AST tmp82_AST = null;
		tmp82_AST = (AST)astFactory.create(LT(1));
		match(LPAREN);
		scoped_name_list();
		if (inputState.guessing==0) {
			astFactory.addASTChild(currentAST, returnAST);
		}
		AST tmp83_AST = null;
		tmp83_AST = (AST)astFactory.create(LT(1));
		match(RPAREN);
		raises_expr_AST = (AST)currentAST.root;
		returnAST = raises_expr_AST;
	}
	
	public final void context_expr() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST context_expr_AST = null;
		
		ContextNode tmp84_AST = null;
		if (inputState.guessing==0) {
			tmp84_AST = new ContextNode(LT(1));
			astFactory.makeASTRoot(currentAST, tmp84_AST);
		}
		match(CONTEXT);
		AST tmp85_AST = null;
		tmp85_AST = (AST)astFactory.create(LT(1));
		match(LPAREN);
		context_string_literal();
		if (inputState.guessing==0) {
			astFactory.addASTChild(currentAST, returnAST);
		}
		{
		_loop121:
		do {
			if ((LA(1)==COMMA)) {
				AST tmp86_AST = null;
				tmp86_AST = (AST)astFactory.create(LT(1));
				match(COMMA);
				context_string_literal();
				if (inputState.guessing==0) {
					astFactory.addASTChild(currentAST, returnAST);
				}
			}
			else {
				break _loop121;
			}
			
		} while (true);
		}
		AST tmp87_AST = null;
		tmp87_AST = (AST)astFactory.create(LT(1));
		match(RPAREN);
		context_expr_AST = (AST)currentAST.root;
		returnAST = context_expr_AST;
	}
	
	public final void param_dcl() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST param_dcl_AST = null;
		AST a_AST = null;
		AST b_AST = null;
		AST name_AST = null;
		
		param_attribute();
		if (inputState.guessing==0) {
			a_AST = (AST)returnAST;
		}
		param_type_spec();
		if (inputState.guessing==0) {
			b_AST = (AST)returnAST;
			astFactory.addASTChild(currentAST, returnAST);
		}
		identifier();
		if (inputState.guessing==0) {
			name_AST = (AST)returnAST;
		}
		if ( inputState.guessing==0 ) {
			param_dcl_AST = (AST)currentAST.root;
			
						param_dcl_AST = (AST)astFactory.make( (new ASTArray(2)).add((AST)astFactory.create(PARAM_DECL)).add(param_dcl_AST));
						((IDLEntityNode)b_AST).setUsed();
						param_dcl_AST.setText(name_AST.getText());
						((ParamDeclNode)param_dcl_AST).setAttribute(a_AST.getText());
						((IDLEntityNode)param_dcl_AST).setLine(((IDLEntityNode)name_AST).getLine());
			
			currentAST.root = param_dcl_AST;
			currentAST.child = param_dcl_AST!=null &&param_dcl_AST.getFirstChild()!=null ?
				param_dcl_AST.getFirstChild() : param_dcl_AST;
			currentAST.advanceChildToEnd();
		}
		param_dcl_AST = (AST)currentAST.root;
		returnAST = param_dcl_AST;
	}
	
	public final void param_attribute() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST param_attribute_AST = null;
		
		switch ( LA(1)) {
		case LITERAL_in:
		{
			AST tmp88_AST = null;
			if (inputState.guessing==0) {
				tmp88_AST = (AST)astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp88_AST);
			}
			match(LITERAL_in);
			param_attribute_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_out:
		{
			AST tmp89_AST = null;
			if (inputState.guessing==0) {
				tmp89_AST = (AST)astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp89_AST);
			}
			match(LITERAL_out);
			param_attribute_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_inout:
		{
			AST tmp90_AST = null;
			if (inputState.guessing==0) {
				tmp90_AST = (AST)astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp90_AST);
			}
			match(LITERAL_inout);
			param_attribute_AST = (AST)currentAST.root;
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		returnAST = param_attribute_AST;
	}
	
	public final void void_type() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST void_type_AST = null;
		Token  x = null;
		AST x_AST = null;
		
		x = LT(1);
		if (inputState.guessing==0) {
			x_AST = (AST)astFactory.create(x);
		}
		match(LITERAL_void);
		if ( inputState.guessing==0 ) {
			void_type_AST = (AST)currentAST.root;
			
						void_type_AST = (AST)astFactory.make( (new ASTArray(2)).add((AST)astFactory.create(BASETYPE)).add(void_type_AST));
				        void_type_AST.setText("void");
						((IDLEntityNode)void_type_AST).setLine(((IDLEntityNode)x_AST).getLine());    
					
			currentAST.root = void_type_AST;
			currentAST.child = void_type_AST!=null &&void_type_AST.getFirstChild()!=null ?
				void_type_AST.getFirstChild() : void_type_AST;
			currentAST.advanceChildToEnd();
		}
		void_type_AST = (AST)currentAST.root;
		returnAST = void_type_AST;
	}
	
	public final void floating_pt_type() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST floating_pt_type_AST = null;
		Token  a = null;
		AST a_AST = null;
		Token  b = null;
		AST b_AST = null;
		Token  c = null;
		AST c_AST = null;
		
		switch ( LA(1)) {
		case LITERAL_float:
		{
			a = LT(1);
			if (inputState.guessing==0) {
				a_AST = (AST)astFactory.create(a);
			}
			match(LITERAL_float);
			if ( inputState.guessing==0 ) {
				floating_pt_type_AST = (AST)currentAST.root;
				
							floating_pt_type_AST = (AST)astFactory.make( (new ASTArray(2)).add((AST)astFactory.create(BASETYPE)).add(floating_pt_type_AST));
				floating_pt_type_AST.setText("float");
							((IDLEntityNode)floating_pt_type_AST).setLine(((IDLEntityNode)a_AST).getLine());
						
				currentAST.root = floating_pt_type_AST;
				currentAST.child = floating_pt_type_AST!=null &&floating_pt_type_AST.getFirstChild()!=null ?
					floating_pt_type_AST.getFirstChild() : floating_pt_type_AST;
				currentAST.advanceChildToEnd();
			}
			floating_pt_type_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_double:
		{
			b = LT(1);
			if (inputState.guessing==0) {
				b_AST = (AST)astFactory.create(b);
			}
			match(LITERAL_double);
			if ( inputState.guessing==0 ) {
				floating_pt_type_AST = (AST)currentAST.root;
				
							floating_pt_type_AST = (AST)astFactory.make( (new ASTArray(2)).add((AST)astFactory.create(BASETYPE)).add(floating_pt_type_AST));
				floating_pt_type_AST.setText("double");
							((IDLEntityNode)floating_pt_type_AST).setLine(((IDLEntityNode)b_AST).getLine());
						
				currentAST.root = floating_pt_type_AST;
				currentAST.child = floating_pt_type_AST!=null &&floating_pt_type_AST.getFirstChild()!=null ?
					floating_pt_type_AST.getFirstChild() : floating_pt_type_AST;
				currentAST.advanceChildToEnd();
			}
			floating_pt_type_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_long:
		{
			c = LT(1);
			if (inputState.guessing==0) {
				c_AST = (AST)astFactory.create(c);
			}
			match(LITERAL_long);
			AST tmp91_AST = null;
			tmp91_AST = (AST)astFactory.create(LT(1));
			match(LITERAL_double);
			if ( inputState.guessing==0 ) {
				floating_pt_type_AST = (AST)currentAST.root;
				
							floating_pt_type_AST = (AST)astFactory.make( (new ASTArray(2)).add((AST)astFactory.create(BASETYPE)).add(floating_pt_type_AST));
							floating_pt_type_AST.setText("long_double");
							((IDLEntityNode)floating_pt_type_AST).setLine(((IDLEntityNode)c_AST).getLine());
						
				currentAST.root = floating_pt_type_AST;
				currentAST.child = floating_pt_type_AST!=null &&floating_pt_type_AST.getFirstChild()!=null ?
					floating_pt_type_AST.getFirstChild() : floating_pt_type_AST;
				currentAST.advanceChildToEnd();
			}
			floating_pt_type_AST = (AST)currentAST.root;
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		returnAST = floating_pt_type_AST;
	}
	
	public final void value_element() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST value_element_AST = null;
		Token  a = null;
		AST a_AST = null;
		Token  b = null;
		AST b_AST = null;
		AST elmt_AST = null;
		
		switch ( LA(1)) {
		case STRUCTURE:
		case UNION:
		case ENUM:
		case TYPEDEF:
		case CONSTANT:
		case ATTRIBUTE:
		case EXCEPT:
		case STRING:
		case FIXED:
		case WSTRING:
		case NATIVE:
		case SCOPEOP:
		case IDENT:
		case LITERAL_readonly:
		case LITERAL_oneway:
		case LITERAL_void:
		case LITERAL_float:
		case LITERAL_double:
		case LITERAL_long:
		case LITERAL_short:
		case LITERAL_unsigned:
		case LITERAL_char:
		case LITERAL_wchar:
		case LITERAL_any:
		case LITERAL_Object:
		case LITERAL_ValueBase:
		case LITERAL_octet:
		case LITERAL_boolean:
		{
			export();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			value_element_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_public:
		case LITERAL_private:
		{
			{
			switch ( LA(1)) {
			case LITERAL_public:
			{
				a = LT(1);
				if (inputState.guessing==0) {
					a_AST = (AST)astFactory.create(a);
					astFactory.addASTChild(currentAST, a_AST);
				}
				match(LITERAL_public);
				break;
			}
			case LITERAL_private:
			{
				b = LT(1);
				if (inputState.guessing==0) {
					b_AST = (AST)astFactory.create(b);
					astFactory.addASTChild(currentAST, b_AST);
				}
				match(LITERAL_private);
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			type_spec();
			identifier();
			if (inputState.guessing==0) {
				elmt_AST = (AST)returnAST;
			}
			AST tmp92_AST = null;
			tmp92_AST = (AST)astFactory.create(LT(1));
			match(SEMI);
			value_element_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_factory:
		{
			init_dcl();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			value_element_AST = (AST)currentAST.root;
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		returnAST = value_element_AST;
	}
	
	public final void value_support_spec() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST value_support_spec_AST = null;
		
		switch ( LA(1)) {
		case SUPPORT:
		{
			SupportNode tmp93_AST = null;
			if (inputState.guessing==0) {
				tmp93_AST = new SupportNode(LT(1));
				astFactory.makeASTRoot(currentAST, tmp93_AST);
			}
			match(SUPPORT);
			scoped_name_list();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			if ( inputState.guessing==0 ) {
				
				//#            #value_support_spec = #([SUPPORT], #value_support_spec);
				//x            ((IDLEntityNode)#value_support_spec).setLine(((IDLEntityNode)#a).getLine());
				
			}
			value_support_spec_AST = (AST)currentAST.root;
			break;
		}
		case EOF:
		{
			value_support_spec_AST = (AST)currentAST.root;
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		returnAST = value_support_spec_AST;
	}
	
	public final void init_dcl() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST init_dcl_AST = null;
		AST name_AST = null;
		
		AST tmp94_AST = null;
		tmp94_AST = (AST)astFactory.create(LT(1));
		match(LITERAL_factory);
		identifier();
		if (inputState.guessing==0) {
			name_AST = (AST)returnAST;
		}
		AST tmp95_AST = null;
		tmp95_AST = (AST)astFactory.create(LT(1));
		match(LPAREN);
		{
		switch ( LA(1)) {
		case LITERAL_in:
		{
			init_param();
			if (inputState.guessing==0) {
				astFactory.addASTChild(currentAST, returnAST);
			}
			{
			_loop151:
			do {
				if ((LA(1)==COMMA)) {
					AST tmp96_AST = null;
					tmp96_AST = (AST)astFactory.create(LT(1));
					match(COMMA);
					init_param();
					if (inputState.guessing==0) {
						astFactory.addASTChild(currentAST, returnAST);
					}
				}
				else {
					break _loop151;
				}
				
			} while (true);
			}
			break;
		}
		case RPAREN:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		AST tmp97_AST = null;
		tmp97_AST = (AST)astFactory.create(LT(1));
		match(RPAREN);
		AST tmp98_AST = null;
		tmp98_AST = (AST)astFactory.create(LT(1));
		match(SEMI);
		init_dcl_AST = (AST)currentAST.root;
		returnAST = init_dcl_AST;
	}
	
	public final void init_param() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST init_param_AST = null;
		AST b_AST = null;
		AST name_AST = null;
		
		AST tmp99_AST = null;
		tmp99_AST = (AST)astFactory.create(LT(1));
		match(LITERAL_in);
		param_type_spec();
		if (inputState.guessing==0) {
			b_AST = (AST)returnAST;
			astFactory.addASTChild(currentAST, returnAST);
		}
		identifier();
		if (inputState.guessing==0) {
			name_AST = (AST)returnAST;
		}
		if ( inputState.guessing==0 ) {
			init_param_AST = (AST)currentAST.root;
			
					init_param_AST = (AST)astFactory.make( (new ASTArray(2)).add((AST)astFactory.create(PARAM_DECL)).add(init_param_AST));
					((IDLEntityNode)b_AST).setUsed();
					init_param_AST.setText(name_AST.getText());
					((ParamDeclNode)init_param_AST).setAttribute("in");
					((IDLEntityNode)init_param_AST).setLine(((IDLEntityNode)name_AST).getLine());
			
			currentAST.root = init_param_AST;
			currentAST.child = init_param_AST!=null &&init_param_AST.getFirstChild()!=null ?
				init_param_AST.getFirstChild() : init_param_AST;
			currentAST.advanceChildToEnd();
		}
		init_param_AST = (AST)currentAST.root;
		returnAST = init_param_AST;
	}
	
	
	public static final String[] _tokenNames = {
		"<0>",
		"EOF",
		"<2>",
		"NULL_TREE_LOOKAHEAD",
		"\"module\"",
		"\"interface\"",
		"\"struct\"",
		"\"union\"",
		"\"enum\"",
		"\"raises\"",
		"\"typedef\"",
		"\"const\"",
		"\"attribute\"",
		"\"exception\"",
		"\"string\"",
		"\"fixed\"",
		"\"wstring\"",
		"\"sequence\"",
		"\"context\"",
		"\"native\"",
		"\"valuetype\"",
		"BASETYPE",
		"SPEC",
		"INHERIT",
		"\"supports\"",
		"ARRAY",
		"CONST_EXP",
		"SCOPED_NAME",
		"TYPE_DECL",
		"OP_DECL",
		"PARAM_DECL",
		"CASE_EXP",
		"LITERAL",
		"PREPROC",
		";",
		"\"local\"",
		"\"abstract\"",
		"\"custom\"",
		"a preprocessor directive",
		"{",
		"}",
		":",
		",",
		"::",
		"=",
		"|",
		"^",
		"&",
		"shift operator",
		"+ or -",
		"MULT_OP",
		"~",
		"(",
		")",
		"a integer, float or fixed literal",
		"OCTAL",
		"a hexadecimal value",
		"a string literal",
		"a wstring literal",
		"FIXED_PT_LITERAL",
		"a character literal",
		"a character literal",
		"a float or fixed literal",
		"IDENT",
		"\"TRUE\"",
		"\"FALSE\"",
		"[",
		"]",
		"\"switch\"",
		"\"case\"",
		"\"default\"",
		"<",
		">",
		"\"readonly\"",
		"\"oneway\"",
		"\"in\"",
		"\"out\"",
		"\"inout\"",
		"\"void\"",
		"\"float\"",
		"\"double\"",
		"\"long\"",
		"\"short\"",
		"\"unsigned\"",
		"\"char\"",
		"\"wchar\"",
		"\"any\"",
		"\"Object\"",
		"\"ValueBase\"",
		"\"octet\"",
		"\"boolean\"",
		"\"public\"",
		"\"private\"",
		"\"factory\"",
		"WS",
		"SL_COMMENT",
		"ML_COMMENT",
		"ASCII_ALPHABETIC",
		".",
		"!",
		"/",
		"*",
		"%",
		"an escape sequence",
		"an escaped character value",
		"a digit",
		"an octal digit",
		"a hexadecimal digit"
	};
	
	private static final long _tokenSet_0_data_[] = { 515397660144L, 0L };
	public static final BitSet _tokenSet_0 = new BitSet(_tokenSet_0_data_);
	private static final long _tokenSet_1_data_[] = { -9223363240761507392L, 134184960L, 0L, 0L };
	public static final BitSet _tokenSet_1 = new BitSet(_tokenSet_1_data_);
	private static final long _tokenSet_2_data_[] = { -9223363240761098816L, 134202880L, 0L, 0L };
	public static final BitSet _tokenSet_2 = new BitSet(_tokenSet_2_data_);
	private static final long _tokenSet_3_data_[] = { -9223363240761098816L, 1073726976L, 0L, 0L };
	public static final BitSet _tokenSet_3 = new BitSet(_tokenSet_3_data_);
	
	}
