package org.aspectix.IDLparser.pub;


/**
 * The representation of an IDL array declaration as a
 * node of an abstract syntax tree.
 */
public interface IDLArray extends IDLNode, IDLType {

    /**
     * Get the defined length of this array.
     * @return this array's length
     * @exception IDLException if the references in the abstract syntax tree
     *  containing this Array have not been completely resolved
     */
    int getLength() throws IDLException;
    
    /**
     * Get the contained type of this array.
     * @return the contained IDLType  
     */
    IDLType getIDLType();

}
