package org.aspectix.IDLparser.pub;

/**
 * The representation of an IDL basetype expression as a
 * node of an abstract syntax tree.
 */
public interface IDLBaseType extends IDLType, IDLNode {

    /**
     * Get the name of this type, that is the concrete type of this
     * basetype ("long", "char", ...)
     * @return this basetype's concrete type as String
     */
    String getName();

    /**
     * Returns true, if this basetype is defined as "void".
     * @return true, if this basetype is void
     */
    boolean isVoid();
 
}
