package org.aspectix.IDLparser.pub;

import java.util.Iterator;


/**
 * The representation of an IDL case expression as a
 * node of an abstract syntax tree.
 */
public interface IDLCase extends IDLNamed, IDLNode {

    /**
     * Get the type of the union-member, which is defined by this case expression.
     * @return type of the union-member
     */ 
    IDLType getIDLType();

    /**
     * Get the name of the union-member, which is defined by this case expression.
     * @return name of the union-member
     */
    String getName();

    /** 
     * Get the discriminaters, which select this case.
     * @return discriminators of this case-expression
     */
    Iterator getDiscriminators(IDLType typeNode) throws IDLException;

}
