package org.aspectix.IDLparser.pub;

import java.math.BigDecimal; 
  
/**
 * The representation of any IDL constant expression as a
 * node of an abstract syntax tree.
 */
public interface IDLConst extends IDLNode {

    /** 
     * Get the value of a constant expression represented as a 
     * Java BigDecimal.
     * @return BigDecimal represetation of constant Expression
     * @exception IDLException if constant Expression cannot be
     * represented as a number
     */
    BigDecimal numberValue() throws IDLException;

    /**
     * Get the value of a constant expression represented as string.
     * @param type the desired type (should be "string", "char" or "boolean");
     * @return String represetation of constant Expression
     * @exception IDLException if the constant expression doesn't fit the 
     * given type
     */
    String stringValue(int type) throws IDLException;
    
}
