package org.aspectix.IDLparser.pub;

import java.math.BigDecimal; 

/**
 * The representation of an IDL constant definition as a
 * node of an abstract syntax tree.
 */
public interface IDLConstDef extends IDLNamed, IDLNode {

    /**
     * Get the name of the defined constant.
     * @return this constant's name
     */
    String getName();

    /**
     * Get the type of the defined constant.
     * @return this constant's IDLType
     * @exception IDLException if the reference to the type could not be resolved
     */
    IDLType getIDLType() throws IDLException;

    /**
     * Get the value, which is assigned to this constant. 
     * @return the value of this constant
     * @exception IDLException if the reference to the value could not be resolved
     */
    Object getValue() throws IDLException;   
}
