package org.aspectix.IDLparser.pub;



/**
 * The representation of an IDL fixed type expression as a
 * node of an abstract syntax tree.
 */
public interface IDLFixed extends IDLType, IDLNode {

    /**
     * Get the number of total digits as defined in this fixed type declaration
     * @return number of total digits
     * @exception IDLException if the constant expression representing the 
     * number could not be resolved
     */
    int getTotal() throws IDLException;

    
    /**
     * Get the number of fractional digits as defined in this fixed type declaration
     * @return number of fractional digits
     * @exception IDLException if the constant expression representing the 
     * number could not be resolved
     */
    int getFractional() throws IDLException;
}
