package org.aspectix.IDLparser.pub;

import java.util.Iterator;

/**
 * The representation of an IDL interface declaration as a
 * node of an abstract syntax tree.
 */
public interface IDLInterf extends IDLScopeForming, IDLNamed, IDLType, IDLNode {
    
    /**
     * Get the name of this interface.
     * @return this interface's name
     */
    String getName();

    /**
     * Returns true, if this interface inherits from another interface.
     * @return true, if this interface inherits
     */
    boolean inherits();
    
    /**
     * Returns true, if this interface declaration is a forward declaration
     * @return true, if this is a forward declaration
     */
    boolean forwardDecl();

    /**
     * Returns true, if this interface declaration is declared with the keyword
     * "local"
     * @return true, if this is a local interface
     */
    boolean localIf();

    /**
     * Returns true, if this interface declaration is declared with the keyword
     * "abstract"
     * @return true, if this is a abstract interface
     */
    boolean abstractIf();
    
    /**
     * Get all Interfaces, from which this interface inherits directly.
     * @return Iterator over this interface's direct base interfaces
     * @exception IDLException if references to base interfaces could not be resolved
     */
    Iterator getDirectBaseInterfaces() throws IDLException;
    
    /**
     * Return all visible (non-redefined) members of this interface.
     * @return Iterator over this interface's visible members
     */
    Iterator getVisibleMembers();
    
    /**
     * Return all members, which have been inherited by this interface 
     * and are visible (not-redefined).
     * @return Iterator over this interface's visible, inherited members
     */
    Iterator getVisibleInheritedMembers();
    
    /**
     * Return all members, which have been defined locally in this interface.
     * @return Iterator over this interface's locally defined members
     */
    Iterator getLocallyDefinedMembers();
    
}
