package org.aspectix.IDLparser.pub;

import java.util.Iterator;

/**
 * The representation of an IDL module declaration as a
 * node of an abstract syntax tree.
 */
public interface IDLModule extends IDLNamed, IDLScopeForming, IDLNode {

    /**
     * Get all definitions inside this module.
     * @return Iterator over the definitions in this module
     */
    Iterator getDefinitions();

    /** 
     * Get the name of this module.
     * @return this module's name
     */
    String getName();

}
