package org.aspectix.IDLparser.pub;

import java.util.*;

/**
 * The representation of any IDL declaration which has 
 * a unique name as a node of an abstract syntax tree.
 */
public interface IDLNamed { 

    /**
     * Get the fully qualified name of this node.
     * @return this node's fully qualified name
     */
    IDLScopeStack getScopedName();

    /**
     * Get the local, non-scoped name of this node.
     * @return this node's local name
     */
    String getLocalName();
}
