package org.aspectix.IDLparser.pub;

import java.util.Iterator;

/**
 * The representation of any IDL expression as a
 * node of an abstract syntax tree.
 */
public interface IDLNode {

    /**
     * Get the line of the IDL-file in which this expression occured.
     * @return this expression's line number
     */
    int getLine();

    /**
     * Get all descendants of this node, whose identifier has been 
     * used in the IDL-file. (see CORBA specification for definition of identifier usage).
     * @return Iterator over this node's used descendants
     */
    Iterator getUsedDescendants();

    /**
     * Get the scope of this IDL expression.
     * @return IDLScopeStack-representation of this expression's scope
     */
    IDLScopeStack getScope();
 
    /** 
     * Get the scope in which this IDL expression has been defined. 
     * Differs from getScope() if this expression has been inherited 
     * by an interface. 
     * @return IDLScopeStack-representation of the scope of this expression's definiton
     */
    IDLScopeStack getDefinitionScope();
    
    /**
     * Get the name, which has been assigned to this expression by
     * a typedef-expression.
     * @return null, if there is no surrounding typedef
     */
    String assignedName();
    
    /**
     * Returns true if this node is visible (not a member in an interface 
     * which has been redefined).
     * @return true if this node is visible
     */
    boolean visible();
}
